/*
 * Decompiled with CFR 0.152.
 */
package bssccom;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.awt.Image;

public class BsscScrollbar
extends Canvas
implements Runnable {
    int m_nMinPos;
    int m_nMaxPos;
    int m_nCurPos;
    int m_nVisible;
    float m_fPosPercent;
    float m_fVisiblePercent;
    int m_nHscrollWidth = 100;
    int m_nHscrollHeight = 16;
    int m_nVscrollWidth = 16;
    int m_nVscrollHeight = 100;
    int m_nVscrollButtonHeight = 16;
    int m_nHscrollButtonWidth = 16;
    int m_nVscrollButtonDefHeight = 16;
    int m_nHscrollButtonDefWidth = 16;
    int m_nMinScrollBarHeight = 8;
    int m_nMinScrollBarWidth = 8;
    int m_nOrientation = 1;
    int m_nHscrollbarPos = -1;
    int m_nHscrollbarWidth = 0;
    int m_nVscrollbarPos = -1;
    int m_nVscrollbarHeight = 0;
    int m_MouseActivedPart = -1;
    int m_nLineIncrement = 1;
    int m_nPageIncrement = 0;
    Image m_bi;
    boolean m_bUpLeftButtonPushed = false;
    boolean m_bDownRightButtonPushed = false;
    boolean m_bMouseDown = false;
    int m_nMousex = -1;
    int m_nMousey = -1;
    int m_nDeltaxforScrollH = 0;
    int m_nDeltayforScrollV = 0;
    int m_nMouseDownTicks = 0;
    private static final int m_nMouseDownRepeatTicks = 3;
    private static final int NOT_ACTIVED = -1;
    private static final int UP_LEFT = 0;
    private static final int DOWN_RIGHT = 1;
    private static final int SCROLLBAR = 2;
    private static final int UP_LEFT_PART = 3;
    private static final int DOWN_RIGHT_PART = 4;
    Color m_ColorBlack = new Color(0, 0, 0);
    Color m_ColorGray = new Color(192, 192, 192);
    Color m_ColorDarkGray = new Color(128, 128, 128);
    Color m_ColorBrightGray = new Color(223, 223, 223);
    Color m_ColorWhite = new Color(255, 255, 255);
    Color m_ColorGrayBlack = new Color(31, 31, 31);
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;

    private void drawButtondownforVerScroll(Graphics graphics, boolean bl, boolean bl2) {
        if (!bl2 && this.m_bDownRightButtonPushed == bl) {
            return;
        }
        this.drawButton(graphics, 0, this.m_nVscrollHeight - this.m_nVscrollButtonHeight, this.m_nVscrollWidth, this.m_nVscrollButtonHeight, bl);
        this.drawTriangleforVertical(graphics, false, bl);
        this.m_bDownRightButtonPushed = bl;
    }

    private void drawScrollBarforVerScroll(Graphics graphics) {
        this.drawButton(graphics, 0, this.m_nVscrollbarPos, this.m_nVscrollWidth, this.m_nVscrollbarHeight, false);
    }

    public int getLineIncrement() {
        return this.m_nLineIncrement;
    }

    public void setLineIncrement(int n) {
        this.m_nLineIncrement = n;
    }

    public int getMaximum() {
        return this.m_nMaxPos;
    }

    private synchronized void doMouseUp(int n, int n2) {
        Graphics graphics = this.m_bi != null ? this.m_bi.getGraphics() : this.getGraphics();
        this.m_bMouseDown = false;
        this.m_nMousex = n;
        this.m_nMousey = n2;
        switch (this.m_MouseActivedPart) {
            case 0: {
                if (this.m_nOrientation == 1) {
                    this.drawButtonupforVerScroll(graphics, false, false);
                    break;
                }
                this.drawButtonleftforHorScroll(graphics, false, false);
                break;
            }
            case 1: {
                if (this.m_nOrientation == 1) {
                    this.drawButtondownforVerScroll(graphics, false, false);
                    break;
                }
                this.drawButtonrightforHorScroll(graphics, false, false);
                break;
            }
            case 2: {
                if (this.m_nOrientation == 1) {
                    this.calScrollBarPosforVscroll();
                } else {
                    this.calScrollBarPosforHscroll();
                }
            }
            case 3: 
            case 4: {
                if (this.m_nOrientation == 1) {
                    this.drawScrollAreaforVerScroll(graphics, false, false);
                    this.drawScrollBarforVerScroll(graphics);
                    break;
                }
                this.drawScrollAreaforHorScroll(graphics, false, false);
                this.drawScrollBarforHorScroll(graphics);
            }
        }
        this.m_MouseActivedPart = -1;
        if (this.m_bi != null) {
            Graphics graphics2 = this.getGraphics();
            graphics2.drawImage(this.m_bi, 0, 0, this);
        }
    }

    private void drawButtonleftforHorScroll(Graphics graphics, boolean bl, boolean bl2) {
        if (!bl2 && this.m_bUpLeftButtonPushed == bl) {
            return;
        }
        this.drawButton(graphics, 0, 0, this.m_nHscrollButtonWidth, this.m_nHscrollHeight, bl);
        this.drawTriangleforHorizontal(graphics, true, bl);
        this.m_bUpLeftButtonPushed = bl;
    }

    private void drawScrollBarforHorScroll(Graphics graphics) {
        this.drawButton(graphics, this.m_nHscrollbarPos, 0, this.m_nHscrollbarWidth, this.m_nHscrollHeight, false);
    }

    private void calScrollBarPosforHscroll() {
        this.scrollPosChanged();
        if (this.m_fPosPercent == -1.0f) {
            return;
        }
        int n = (int)(this.m_fVisiblePercent * (float)(this.m_nHscrollWidth - 2 * this.m_nHscrollButtonWidth));
        if (n < this.m_nMinScrollBarWidth) {
            n = this.m_nMinScrollBarWidth;
        }
        if (n + 2 * this.m_nHscrollButtonWidth > this.m_nHscrollWidth) {
            this.m_nHscrollbarPos = -1;
            this.m_nHscrollbarWidth = 0;
            return;
        }
        int n2 = (int)(this.m_fPosPercent * (float)(this.m_nHscrollWidth - n - 2 * this.m_nHscrollButtonWidth));
        if (n2 < 0 || n < 0) {
            return;
        }
        this.m_nHscrollbarPos = n2 + this.m_nHscrollButtonWidth;
        this.m_nHscrollbarWidth = n;
        if (this.m_nHscrollbarPos >= this.m_nHscrollWidth - this.m_nHscrollButtonWidth - n) {
            this.m_nHscrollbarPos = this.m_nHscrollWidth - this.m_nHscrollButtonWidth - n;
        }
    }

    private void calScrollBarPosforVscroll() {
        this.scrollPosChanged();
        if (this.m_fPosPercent == -1.0f) {
            return;
        }
        int n = (int)(this.m_fVisiblePercent * (float)(this.m_nVscrollHeight - 2 * this.m_nVscrollButtonHeight));
        if (n < this.m_nMinScrollBarHeight) {
            n = this.m_nMinScrollBarHeight;
        }
        if (n + 2 * this.m_nVscrollButtonHeight > this.m_nVscrollHeight) {
            this.m_nVscrollbarPos = -1;
            this.m_nVscrollbarHeight = 0;
            return;
        }
        int n2 = (int)(this.m_fPosPercent * (float)(this.m_nVscrollHeight - n - 2 * this.m_nVscrollButtonHeight));
        if (n2 < 0 || n < 0) {
            return;
        }
        this.m_nVscrollbarPos = n2 + this.m_nVscrollButtonHeight;
        this.m_nVscrollbarHeight = n;
        if (this.m_nVscrollbarPos >= this.m_nVscrollHeight - this.m_nVscrollButtonHeight - n) {
            this.m_nVscrollbarPos = this.m_nVscrollHeight - this.m_nVscrollButtonHeight - n;
        }
    }

    public Dimension preferredSize() {
        Dimension dimension = new Dimension();
        if (this.m_nOrientation == 1) {
            dimension.width = this.m_nVscrollWidth;
            dimension.height = this.m_nVscrollHeight;
        } else {
            dimension.width = this.m_nHscrollWidth;
            dimension.height = this.m_nHscrollHeight;
        }
        return dimension;
    }

    private synchronized void goUpLeftOnePageforScroll(Graphics graphics) {
        if (this.m_nCurPos <= this.m_nMinPos) {
            this.m_nCurPos = this.m_nMinPos;
            return;
        }
        if (this.m_nCurPos >= this.m_nMaxPos) {
            this.m_nCurPos = this.m_nMaxPos;
        }
        this.m_nCurPos -= this.m_nPageIncrement;
        if (this.m_nCurPos <= this.m_nMinPos) {
            this.m_nCurPos = this.m_nMinPos;
        }
        if (this.m_nOrientation == 1) {
            this.calScrollBarPosforVscroll();
            this.drawScrollAreaforVerScroll(graphics, true, true);
            this.drawScrollBarforVerScroll(graphics);
        } else {
            this.calScrollBarPosforHscroll();
            this.drawScrollAreaforHorScroll(graphics, true, true);
            this.drawScrollBarforHorScroll(graphics);
        }
        if (this.getParent() != null) {
            this.getParent().deliverEvent(new Event(this, 603, null));
        }
    }

    private synchronized void goDownRightOneLineforScroll(Graphics graphics) {
        if (this.m_nOrientation == 1) {
            this.drawButtondownforVerScroll(graphics, true, false);
        } else {
            this.drawButtonrightforHorScroll(graphics, true, false);
        }
        if (this.m_nCurPos <= this.m_nMinPos) {
            this.m_nCurPos = this.m_nMinPos;
        }
        if (this.m_nCurPos >= this.m_nMaxPos) {
            this.m_nCurPos = this.m_nMaxPos;
            return;
        }
        this.m_nCurPos += this.m_nLineIncrement;
        if (this.m_nCurPos >= this.m_nMaxPos) {
            this.m_nCurPos = this.m_nMaxPos;
        }
        if (this.m_nOrientation == 1) {
            this.calScrollBarPosforVscroll();
            this.drawScrollAreaforVerScroll(graphics, false, false);
            this.drawScrollBarforVerScroll(graphics);
        } else {
            this.calScrollBarPosforHscroll();
            this.drawScrollAreaforHorScroll(graphics, false, false);
            this.drawScrollBarforHorScroll(graphics);
        }
        if (this.getParent() != null) {
            this.getParent().deliverEvent(new Event(this, 602, null));
        }
    }

    private void drawTriangleforHorizontal(Graphics graphics, boolean bl, boolean bl2) {
        int n = this.m_nHscrollButtonWidth / 4 - 1;
        int n2 = n * 2;
        int n3 = this.m_nHscrollHeight / 2 - (n + 1);
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (bl) {
            nArray[0] = --n2 + n;
            nArray[1] = n2;
            nArray[2] = n2 + n;
        } else {
            n2 = this.m_nHscrollWidth - n2 - 1;
            nArray[0] = n2 - n;
            nArray[1] = n2;
            nArray[2] = n2 - n;
        }
        nArray2[0] = n3;
        nArray2[1] = n3 + n;
        nArray2[2] = n3 + n * 2;
        if (bl2) {
            int n4 = 0;
            do {
                int n5 = n4;
                nArray[n5] = nArray[n5] + 1;
                int n6 = n4++;
                nArray2[n6] = nArray2[n6] + 1;
            } while (n4 < 3);
        }
        graphics.setColor(this.m_ColorBlack);
        graphics.drawPolygon(nArray, nArray2, 3);
        graphics.drawLine(nArray[0], nArray2[0], nArray[2], nArray2[2]);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    private void determineClickPartVertical(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.m_nVscrollWidth || n2 >= this.m_nVscrollHeight) {
            this.m_MouseActivedPart = -1;
            return;
        }
        if (n2 < this.m_nVscrollButtonHeight) {
            this.m_MouseActivedPart = 0;
            return;
        }
        if (n2 > this.m_nVscrollHeight - this.m_nVscrollButtonHeight) {
            this.m_MouseActivedPart = 1;
            return;
        }
        if (this.m_nVscrollbarPos >= 0) {
            if (n2 >= this.m_nVscrollButtonHeight && n2 < this.m_nVscrollbarPos) {
                this.m_MouseActivedPart = 3;
                return;
            }
            if (n2 >= this.m_nVscrollbarPos && n2 <= this.m_nVscrollbarPos + this.m_nVscrollbarHeight) {
                this.m_MouseActivedPart = 2;
                return;
            }
            if (n2 >= this.m_nVscrollbarPos + this.m_nVscrollbarHeight && n2 <= this.m_nVscrollHeight - this.m_nVscrollButtonHeight) {
                this.m_MouseActivedPart = 4;
                return;
            }
        } else {
            this.m_MouseActivedPart = -1;
        }
    }

    protected String paramString() {
        return "BsscScrollbar";
    }

    private synchronized void doMouseDown(int n, int n2) {
        this.m_nDeltaxforScrollH = this.m_nHscrollbarPos - n;
        this.m_nDeltayforScrollV = this.m_nVscrollbarPos - n2;
        this.m_bMouseDown = true;
        this.m_nMousex = n;
        this.m_nMousey = n2;
        Graphics graphics = this.m_bi != null ? this.m_bi.getGraphics() : this.getGraphics();
        this.determineClickPart(n, n2);
        switch (this.m_MouseActivedPart) {
            case 0: {
                this.goUpLeftOneLineforScroll(graphics);
                break;
            }
            case 1: {
                this.goDownRightOneLineforScroll(graphics);
                break;
            }
            case 3: {
                this.goUpLeftOnePageforScroll(graphics);
                break;
            }
            case 4: {
                this.goDownRightOnePageforScroll(graphics);
            }
        }
        if (this.m_bi != null) {
            Graphics graphics2 = this.getGraphics();
            graphics2.drawImage(this.m_bi, 0, 0, this);
        }
    }

    private void getPositionFromScrollbar() {
        int n;
        int n2;
        if (this.m_nOrientation == 1) {
            n2 = this.m_nMousey + this.m_nDeltayforScrollV - this.m_nVscrollButtonHeight;
            n = this.m_nVscrollHeight - this.m_nVscrollButtonHeight * 2 - this.m_nVscrollbarHeight;
            if (n2 >= n) {
                n2 = n;
            }
            if (n2 <= 0) {
                n2 = 0;
            }
            this.m_nVscrollbarPos = n2 + this.m_nVscrollButtonHeight;
        } else {
            n2 = this.m_nMousex + this.m_nDeltaxforScrollH - this.m_nHscrollButtonWidth;
            n = this.m_nHscrollWidth - this.m_nHscrollButtonWidth * 2 - this.m_nHscrollbarWidth;
            if (n2 >= n) {
                n2 = n;
            }
            if (n2 <= 0) {
                n2 = 0;
            }
            this.m_nHscrollbarPos = n2 + this.m_nHscrollButtonWidth;
        }
        float f = (float)n2 / (float)n;
        if (f >= 1.0f) {
            f = 1.0f;
        }
        if (f <= 0.0f) {
            f = 0.0f;
        }
        this.m_nCurPos = (int)((float)this.m_nMinPos + (float)(this.m_nMaxPos - this.m_nMinPos) * f);
    }

    public void setValue(int n) {
        if (n < this.m_nMinPos || n > this.m_nMaxPos) {
            return;
        }
        this.m_nCurPos = n;
        Graphics graphics = this.m_bi != null ? this.m_bi.getGraphics() : this.getGraphics();
        if (this.getParent() != null) {
            this.getParent().deliverEvent(new Event(this, 605, null));
        }
        if (this.m_nOrientation == 1) {
            this.calScrollBarPosforVscroll();
            this.drawScrollAreaforVerScroll(graphics, false, false);
            this.drawScrollBarforVerScroll(graphics);
        } else {
            this.calScrollBarPosforHscroll();
            this.drawScrollAreaforHorScroll(graphics, false, false);
            this.drawScrollBarforHorScroll(graphics);
        }
        if (this.m_bi != null) {
            Graphics graphics2 = this.getGraphics();
            graphics2.drawImage(this.m_bi, 0, 0, this);
        }
    }

    private void scrollPosChanged() {
        if (this.m_nMaxPos <= this.m_nMinPos) {
            this.m_fPosPercent = -1.0f;
            return;
        }
        this.m_fPosPercent = (float)(this.m_nCurPos - this.m_nMinPos) / (float)(this.m_nMaxPos - this.m_nMinPos);
        this.m_fVisiblePercent = (float)this.m_nVisible / (float)(this.m_nMaxPos + this.m_nVisible - this.m_nMinPos);
    }

    public int getValue() {
        return this.m_nCurPos;
    }

    public int getMinimum() {
        return this.m_nMinPos;
    }

    private synchronized void doMouseDrag(int n, int n2) {
        this.m_nMousex = n;
        this.m_nMousey = n2;
        Graphics graphics = this.m_bi != null ? this.m_bi.getGraphics() : this.getGraphics();
        int n3 = this.m_MouseActivedPart;
        this.determineClickPart(n, n2);
        if (this.m_MouseActivedPart != n3) {
            switch (n3) {
                case 0: {
                    if (this.m_nOrientation == 1) {
                        this.drawButtonupforVerScroll(graphics, false, false);
                        break;
                    }
                    this.drawButtonleftforHorScroll(graphics, false, false);
                    break;
                }
                case 1: {
                    if (this.m_nOrientation == 1) {
                        this.drawButtondownforVerScroll(graphics, false, false);
                        break;
                    }
                    this.drawButtonrightforHorScroll(graphics, false, false);
                    break;
                }
                case 2: {
                    this.doDragScrollBar(graphics);
                    break;
                }
                case 3: 
                case 4: {
                    if (this.m_nOrientation == 1) {
                        this.drawScrollAreaforVerScroll(graphics, false, false);
                        this.drawScrollBarforVerScroll(graphics);
                        break;
                    }
                    this.drawScrollAreaforHorScroll(graphics, false, false);
                    this.drawScrollBarforHorScroll(graphics);
                }
            }
            this.m_MouseActivedPart = n3;
        } else if (this.m_MouseActivedPart == 2) {
            this.doDragScrollBar(graphics);
        }
        if (this.m_bi != null) {
            Graphics graphics2 = this.getGraphics();
            graphics2.drawImage(this.m_bi, 0, 0, this);
        }
    }

    public BsscScrollbar() {
        this(1);
    }

    public BsscScrollbar(int n) {
        this(n, 0, 10, 0, 100);
    }

    public BsscScrollbar(int n, int n2, int n3, int n4, int n5) {
        this.m_nOrientation = n == 0 ? n : 1;
        this.m_nMinPos = n4;
        this.m_nMaxPos = n5 - n3;
        this.m_nCurPos = n2;
        this.m_nVisible = n3;
        Thread thread = new Thread(this);
        thread.start();
        this.m_nPageIncrement = this.m_nVisible;
    }

    public void paint(Graphics graphics) {
        this.m_bi = this.createImage(this.size().width, this.size().height);
        Graphics graphics2 = this.m_bi.getGraphics();
        if (this.m_nOrientation != 0) {
            this.m_nVscrollWidth = this.size().width;
            this.m_nVscrollHeight = this.size().height;
            this.m_nVscrollButtonHeight = this.m_nVscrollButtonDefHeight;
            if (this.m_nVscrollButtonHeight > this.m_nVscrollWidth) {
                this.m_nVscrollButtonHeight = this.m_nVscrollWidth;
            }
            if (this.m_nVscrollButtonHeight > this.m_nVscrollHeight / 2) {
                this.m_nVscrollButtonHeight = this.m_nVscrollHeight / 2;
            }
            this.drawButtonupforVerScroll(graphics2, false, true);
            this.drawButtondownforVerScroll(graphics2, false, true);
            this.calScrollBarPosforVscroll();
            this.drawScrollAreaforVerScroll(graphics2, false, false);
            this.drawScrollBarforVerScroll(graphics2);
        } else {
            this.m_nHscrollWidth = this.size().width;
            this.m_nHscrollHeight = this.size().height;
            this.m_nHscrollButtonWidth = this.m_nHscrollButtonDefWidth;
            if (this.m_nHscrollButtonWidth > this.m_nHscrollHeight) {
                this.m_nHscrollButtonWidth = this.m_nHscrollHeight;
            }
            if (this.m_nHscrollButtonWidth > this.m_nHscrollWidth / 2) {
                this.m_nHscrollButtonWidth = this.m_nHscrollWidth / 2;
            }
            this.drawButtonleftforHorScroll(graphics2, false, true);
            this.drawButtonrightforHorScroll(graphics2, false, true);
            this.calScrollBarPosforHscroll();
            this.drawScrollAreaforHorScroll(graphics2, false, false);
            this.drawScrollBarforHorScroll(graphics2);
        }
        graphics.drawImage(this.m_bi, 0, 0, this);
    }

    public int getVisible() {
        return this.m_nVisible;
    }

    private void drawButtonupforVerScroll(Graphics graphics, boolean bl, boolean bl2) {
        if (!bl2 && this.m_bUpLeftButtonPushed == bl) {
            return;
        }
        this.drawButton(graphics, 0, 0, this.m_nVscrollWidth, this.m_nVscrollButtonHeight, bl);
        this.drawTriangleforVertical(graphics, true, bl);
        this.m_bUpLeftButtonPushed = bl;
    }

    private void drawScrollAreaforHorScroll(Graphics graphics, boolean bl, boolean bl2) {
        graphics.setColor(this.m_ColorDarkGray);
        graphics.drawLine(this.m_nHscrollButtonWidth, 0, this.m_nHscrollWidth - this.m_nHscrollButtonWidth - 1, 0);
        graphics.drawLine(this.m_nHscrollButtonWidth, this.m_nHscrollHeight - 1, this.m_nHscrollWidth - this.m_nHscrollButtonWidth - 1, this.m_nHscrollHeight - 1);
        graphics.setColor(this.m_ColorGray);
        graphics.drawLine(this.m_nHscrollButtonWidth, 1, this.m_nHscrollWidth - this.m_nHscrollButtonWidth - 1, 1);
        graphics.drawLine(this.m_nHscrollButtonWidth, this.m_nHscrollHeight - 2, this.m_nHscrollWidth - this.m_nHscrollButtonWidth - 1, this.m_nHscrollHeight - 2);
        if (!bl) {
            graphics.setColor(this.m_ColorBrightGray);
            graphics.fillRect(this.m_nHscrollButtonWidth, 2, this.m_nHscrollWidth - this.m_nHscrollButtonWidth * 2, this.m_nHscrollHeight - 4);
            return;
        }
        if (bl2) {
            graphics.setColor(this.m_ColorGrayBlack);
            graphics.fillRect(this.m_nHscrollButtonWidth, 2, this.m_nHscrollbarPos - this.m_nHscrollButtonWidth, this.m_nHscrollHeight - 4);
            graphics.setColor(this.m_ColorBrightGray);
            graphics.fillRect(this.m_nHscrollbarPos + this.m_nHscrollbarWidth, 2, this.m_nHscrollWidth - this.m_nHscrollButtonWidth - this.m_nHscrollbarPos - this.m_nHscrollbarWidth, this.m_nHscrollHeight - 4);
            return;
        }
        graphics.setColor(this.m_ColorBrightGray);
        graphics.fillRect(this.m_nHscrollButtonWidth, 2, this.m_nHscrollbarPos - this.m_nHscrollButtonWidth, this.m_nHscrollHeight - 4);
        graphics.setColor(this.m_ColorGrayBlack);
        graphics.fillRect(this.m_nHscrollbarPos + this.m_nHscrollbarWidth, 2, this.m_nHscrollWidth - this.m_nHscrollButtonWidth - this.m_nHscrollbarPos - this.m_nHscrollbarWidth, this.m_nHscrollHeight - 4);
    }

    public void setValues(int n, int n2, int n3, int n4) {
        this.m_nVisible = n2;
        this.m_nPageIncrement = n2;
        this.m_nMinPos = n3;
        this.m_nMaxPos = n4 - n2;
        this.setValue(n);
    }

    private synchronized void goUpLeftOneLineforScroll(Graphics graphics) {
        if (this.m_nOrientation == 1) {
            this.drawButtonupforVerScroll(graphics, true, false);
        } else {
            this.drawButtonleftforHorScroll(graphics, true, false);
        }
        if (this.m_nCurPos <= this.m_nMinPos) {
            this.m_nCurPos = this.m_nMinPos;
            return;
        }
        if (this.m_nCurPos >= this.m_nMaxPos) {
            this.m_nCurPos = this.m_nMaxPos;
        }
        this.m_nCurPos -= this.m_nLineIncrement;
        if (this.m_nCurPos <= this.m_nMinPos) {
            this.m_nCurPos = this.m_nMinPos;
        }
        if (this.m_nOrientation == 1) {
            this.calScrollBarPosforVscroll();
            this.drawScrollAreaforVerScroll(graphics, false, false);
            this.drawScrollBarforVerScroll(graphics);
        } else {
            this.calScrollBarPosforHscroll();
            this.drawScrollAreaforHorScroll(graphics, false, false);
            this.drawScrollBarforHorScroll(graphics);
        }
        if (this.getParent() != null) {
            this.getParent().deliverEvent(new Event(this, 601, null));
        }
    }

    private void doDragScrollBar(Graphics graphics) {
        this.getPositionFromScrollbar();
        if (this.getParent() != null) {
            this.getParent().deliverEvent(new Event(this, 605, null));
        }
        if (this.m_nOrientation == 1) {
            this.drawScrollAreaforVerScroll(graphics, false, false);
            this.drawScrollBarforVerScroll(graphics);
            return;
        }
        this.drawScrollAreaforHorScroll(graphics, false, false);
        this.drawScrollBarforHorScroll(graphics);
    }

    private void drawTriangleforVertical(Graphics graphics, boolean bl, boolean bl2) {
        int n = this.m_nVscrollButtonHeight / 4 - 1;
        int n2 = this.m_nVscrollWidth / 2 - (n + 1);
        int n3 = n * 2;
        int[] nArray = new int[3];
        int[] nArray2 = new int[3];
        if (bl) {
            nArray2[0] = n3 + n;
            nArray2[1] = n3;
            nArray2[2] = n3 + n;
        } else {
            n3 = this.m_nVscrollHeight - n3 - 1;
            nArray2[0] = n3 - n;
            nArray2[1] = n3;
            nArray2[2] = n3 - n;
        }
        nArray[0] = n2;
        nArray[1] = n2 + n;
        nArray[2] = n2 + n * 2;
        if (bl2) {
            int n4 = 0;
            do {
                int n5 = n4;
                nArray[n5] = nArray[n5] + 1;
                int n6 = n4++;
                nArray2[n6] = nArray2[n6] + 1;
            } while (n4 < 3);
        }
        graphics.setColor(this.m_ColorBlack);
        graphics.drawPolygon(nArray, nArray2, 3);
        graphics.drawLine(nArray[0], nArray2[0], nArray[2], nArray2[2]);
        graphics.fillPolygon(nArray, nArray2, 3);
    }

    private void drawButtonrightforHorScroll(Graphics graphics, boolean bl, boolean bl2) {
        if (!bl2 && this.m_bDownRightButtonPushed == bl) {
            return;
        }
        this.drawButton(graphics, this.m_nHscrollWidth - this.m_nHscrollButtonWidth, 0, this.m_nHscrollButtonWidth, this.m_nHscrollHeight, bl);
        this.drawTriangleforHorizontal(graphics, false, bl);
        this.m_bDownRightButtonPushed = bl;
    }

    private void drawScrollAreaforVerScroll(Graphics graphics, boolean bl, boolean bl2) {
        graphics.setColor(this.m_ColorDarkGray);
        graphics.drawLine(0, this.m_nVscrollButtonHeight, 0, this.m_nVscrollHeight - this.m_nVscrollButtonHeight - 1);
        graphics.drawLine(this.m_nVscrollWidth - 1, this.m_nVscrollButtonHeight, this.m_nVscrollWidth - 1, this.m_nVscrollHeight - this.m_nVscrollButtonHeight - 1);
        graphics.setColor(this.m_ColorGray);
        graphics.drawLine(1, this.m_nVscrollButtonHeight, 1, this.m_nVscrollHeight - this.m_nVscrollButtonHeight - 1);
        graphics.drawLine(this.m_nVscrollWidth - 2, this.m_nVscrollButtonHeight, this.m_nVscrollWidth - 2, this.m_nVscrollHeight - this.m_nVscrollButtonHeight - 1);
        if (!bl) {
            graphics.setColor(this.m_ColorBrightGray);
            graphics.fillRect(2, this.m_nVscrollButtonHeight, this.m_nVscrollWidth - 4, this.m_nVscrollHeight - this.m_nVscrollButtonHeight * 2);
            return;
        }
        if (bl2) {
            graphics.setColor(this.m_ColorGrayBlack);
            graphics.fillRect(2, this.m_nVscrollButtonHeight, this.m_nVscrollWidth - 4, this.m_nVscrollbarPos - this.m_nVscrollButtonHeight);
            graphics.setColor(this.m_ColorBrightGray);
            graphics.fillRect(2, this.m_nVscrollbarPos + this.m_nVscrollbarHeight, this.m_nVscrollWidth - 4, this.m_nVscrollHeight - this.m_nVscrollButtonHeight - this.m_nVscrollbarPos - this.m_nVscrollbarHeight);
            return;
        }
        graphics.setColor(this.m_ColorBrightGray);
        graphics.fillRect(2, this.m_nVscrollButtonHeight, this.m_nVscrollWidth - 4, this.m_nVscrollbarPos - this.m_nVscrollButtonHeight);
        graphics.setColor(this.m_ColorGrayBlack);
        graphics.fillRect(2, this.m_nVscrollbarPos + this.m_nVscrollbarHeight, this.m_nVscrollWidth - 4, this.m_nVscrollHeight - this.m_nVscrollButtonHeight - this.m_nVscrollbarPos - this.m_nVscrollbarHeight);
    }

    private void drawButton(Graphics graphics, int n, int n2, int n3, int n4, boolean bl) {
        if (!bl) {
            graphics.setColor(this.m_ColorBlack);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
            graphics.setColor(this.m_ColorBrightGray);
            graphics.drawRect(n, n2, n3 - 2, n4 - 2);
            graphics.setColor(this.m_ColorDarkGray);
            graphics.drawRect(n + 1, n2 + 1, n3 - 3, n4 - 3);
            graphics.setColor(this.m_ColorWhite);
            graphics.drawRect(n + 1, n2 + 1, n3 - 4, n4 - 4);
            graphics.setColor(this.m_ColorGray);
            graphics.fillRect(n + 2, n2 + 2, n3 - 4, n4 - 4);
            return;
        }
        graphics.setColor(this.m_ColorDarkGray);
        graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        graphics.setColor(this.m_ColorGray);
        graphics.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
    }

    private synchronized void goDownRightOnePageforScroll(Graphics graphics) {
        if (this.m_nCurPos <= this.m_nMinPos) {
            this.m_nCurPos = this.m_nMinPos;
        }
        if (this.m_nCurPos >= this.m_nMaxPos) {
            this.m_nCurPos = this.m_nMaxPos;
            return;
        }
        this.m_nCurPos += this.m_nPageIncrement;
        if (this.m_nCurPos >= this.m_nMaxPos) {
            this.m_nCurPos = this.m_nMaxPos;
        }
        if (this.m_nOrientation == 1) {
            this.calScrollBarPosforVscroll();
            this.drawScrollAreaforVerScroll(graphics, true, false);
            this.drawScrollBarforVerScroll(graphics);
        } else {
            this.calScrollBarPosforHscroll();
            this.drawScrollAreaforHorScroll(graphics, true, false);
            this.drawScrollBarforHorScroll(graphics);
        }
        if (this.getParent() != null) {
            this.getParent().deliverEvent(new Event(this, 604, null));
        }
    }

    public void run() {
        while (true) {
            this.checkMouseState();
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
                continue;
            }
            break;
        }
    }

    public boolean handleEvent(Event event) {
        if (event.target != this) {
            return true;
        }
        switch (event.id) {
            case 501: {
                this.m_nMouseDownTicks = 0;
                this.doMouseDown(event.x, event.y);
                break;
            }
            case 502: {
                this.doMouseUp(event.x, event.y);
                break;
            }
            case 506: {
                this.doMouseDrag(event.x, event.y);
                break;
            }
            default: {
                return super.handleEvent(event);
            }
            case 504: 
            case 505: 
        }
        return true;
    }

    private synchronized void checkMouseState() {
        if (this.m_bMouseDown) {
            if (this.m_nMouseDownTicks < 3) {
                ++this.m_nMouseDownTicks;
                return;
            }
            int n = this.m_MouseActivedPart;
            this.determineClickPart(this.m_nMousex, this.m_nMousey);
            int n2 = this.m_MouseActivedPart;
            if (n2 == n) {
                this.doMouseDown(this.m_nMousex, this.m_nMousey);
                return;
            }
            this.m_MouseActivedPart = n;
        }
    }

    public int getPageIncrement() {
        return this.m_nPageIncrement;
    }

    public void setPageIncrement(int n) {
        this.m_nPageIncrement = n;
    }

    private void determineClickPartHorizontal(int n, int n2) {
        if (n < 0 || n2 < 0 || n >= this.m_nHscrollWidth || n2 >= this.m_nHscrollHeight) {
            this.m_MouseActivedPart = -1;
            return;
        }
        if (n < this.m_nHscrollButtonWidth) {
            this.m_MouseActivedPart = 0;
            return;
        }
        if (n > this.m_nHscrollWidth - this.m_nHscrollButtonWidth) {
            this.m_MouseActivedPart = 1;
            return;
        }
        if (this.m_nHscrollbarPos >= 0) {
            if (n >= this.m_nHscrollButtonWidth && n < this.m_nHscrollbarPos) {
                this.m_MouseActivedPart = 3;
                return;
            }
            if (n >= this.m_nHscrollbarPos && n <= this.m_nHscrollbarPos + this.m_nHscrollbarWidth) {
                this.m_MouseActivedPart = 2;
                return;
            }
            if (n >= this.m_nHscrollbarPos + this.m_nHscrollbarWidth && n <= this.m_nHscrollWidth - this.m_nHscrollButtonWidth) {
                this.m_MouseActivedPart = 4;
                return;
            }
        } else {
            this.m_MouseActivedPart = -1;
        }
    }

    private void determineClickPart(int n, int n2) {
        if (this.m_nOrientation == 1) {
            this.determineClickPartVertical(n, n2);
            return;
        }
        this.determineClickPartHorizontal(n, n2);
    }

    public int getOrientation() {
        return this.m_nOrientation;
    }
}

