/*
 * Decompiled with CFR 0.152.
 */
package sitemap;

import java.io.IOException;
import sitemap.HtmlEndTag;
import sitemap.HtmlTag;
import sitemap.LiEndTag;
import sitemap.LiTag;
import sitemap.MyBufferedInputStream;
import sitemap.ObjectEndTag;
import sitemap.ObjectTag;
import sitemap.ParamTag;
import sitemap.TagInvalidException;
import sitemap.UlEndTag;
import sitemap.UlTag;

public class Tag {
    protected static Tag parseHTags(char[] cArray, int n) {
        if (cArray[n] != 't' && cArray[n] != 'T') {
            return new Tag();
        }
        if (cArray[++n] != 'm' && cArray[n] != 'M') {
            return new Tag();
        }
        if (cArray[++n] != 'l' && cArray[n] != 'L') {
            return new Tag();
        }
        if (cArray[++n] != '\u0000') {
            return new Tag();
        }
        return new HtmlTag();
    }

    protected static Tag parseUTags(char[] cArray, int n) {
        if (cArray[n] != 'l' && cArray[n] != 'L') {
            return new Tag();
        }
        if (cArray[++n] != '\u0000') {
            return new Tag();
        }
        return new UlTag();
    }

    protected static Tag parseTag(char[] cArray, int n) {
        switch (cArray[n]) {
            case 'H': 
            case 'h': {
                return Tag.parseHTags(cArray, n + 1);
            }
            case 'O': 
            case 'o': {
                return Tag.parseOTags(cArray, n + 1);
            }
            case 'L': 
            case 'l': {
                return Tag.parseLTags(cArray, n + 1);
            }
            case 'P': 
            case 'p': {
                return Tag.parsePTags(cArray, n + 1);
            }
            case 'U': 
            case 'u': {
                return Tag.parseUTags(cArray, n + 1);
            }
            case '!': {
                return Tag.parseCommentTag(cArray, n + 1);
            }
            case '/': {
                return Tag.parseEndTags(cArray, n + 1);
            }
        }
        return new Tag();
    }

    protected Tag() {
    }

    protected static Tag parseHEndTags(char[] cArray, int n) {
        if (cArray[n] != 't' && cArray[n] != 'T') {
            return new Tag();
        }
        if (cArray[++n] != 'm' && cArray[n] != 'M') {
            return new Tag();
        }
        if (cArray[++n] != 'l' && cArray[n] != 'L') {
            return new Tag();
        }
        if (cArray[++n] != '\u0000') {
            return new Tag();
        }
        return new HtmlEndTag();
    }

    protected static Tag parseLTags(char[] cArray, int n) {
        if (cArray[n] != 'i' && cArray[n] != 'I') {
            return new Tag();
        }
        if (cArray[++n] != '\u0000') {
            return new Tag();
        }
        return new LiTag();
    }

    protected static Tag parseUEndTags(char[] cArray, int n) {
        if (cArray[n] != 'l' && cArray[n] != 'L') {
            return new Tag();
        }
        if (cArray[++n] != '\u0000') {
            return new Tag();
        }
        return new UlEndTag();
    }

    protected static Tag parseCommentTag(char[] cArray, int n) {
        return new Tag();
    }

    protected static Tag parseOTags(char[] cArray, int n) {
        if (cArray[n] != 'b' && cArray[n] != 'B') {
            return new Tag();
        }
        if (cArray[++n] != 'j' && cArray[n] != 'J') {
            return new Tag();
        }
        if (cArray[++n] != 'e' && cArray[n] != 'E') {
            return new Tag();
        }
        if (cArray[++n] != 'c' && cArray[n] != 'C') {
            return new Tag();
        }
        if (cArray[++n] != 't' && cArray[n] != 'T') {
            return new Tag();
        }
        if (cArray[++n] > ' ') {
            return new Tag();
        }
        ++n;
        while (cArray[n] <= ' ' && cArray[n] != '\u0000') {
            ++n;
        }
        String string = new String(cArray);
        return new ObjectTag(string, n);
    }

    protected static Tag parsePTags(char[] cArray, int n) {
        if (cArray[n] != 'a' && cArray[n] != 'A') {
            return new Tag();
        }
        if (cArray[++n] != 'r' && cArray[n] != 'R') {
            return new Tag();
        }
        if (cArray[++n] != 'a' && cArray[n] != 'A') {
            return new Tag();
        }
        if (cArray[++n] != 'm' && cArray[n] != 'M') {
            return new Tag();
        }
        if (cArray[++n] > ' ') {
            return new Tag();
        }
        ++n;
        while (cArray[n] <= ' ' && cArray[n] != '\u0000') {
            ++n;
        }
        String string = new String(cArray);
        return new ParamTag(string, n);
    }

    protected static Tag parseLEndTags(char[] cArray, int n) {
        if (cArray[n] != 'i' && cArray[n] != 'I') {
            return new Tag();
        }
        if (cArray[++n] != '\u0000') {
            return new Tag();
        }
        return new LiEndTag();
    }

    /*
     * Unable to fully structure code
     */
    public static Tag readTag(MyBufferedInputStream var0) throws TagInvalidException {
        var1_1 = new char[256];
        var2_2 = null;
        try {
            var4_3 = false;
            var5_4 = 0;
            var3_5 = -1;
            var3_5 = var0.read();
            while (var3_5 != -1) {
                if (var4_3) {
                    block12: {
                        if (var3_5 == 62) {
                            var4_3 = false;
                            break;
                        }
                        try {
                            var1_1[var5_4] = var3_5 < 0 ? (char)(var3_5 + 256) : (char)var3_5;
                            break block12;
                        }
                        catch (ArrayIndexOutOfBoundsException var6_7) {
                            var6_7.printStackTrace();
                            var7_8 = new char[var1_1.length + var1_1.length];
                            var8_9 = 0;
                            ** while (var8_9 < var1_1.length)
                        }
lbl-1000:
                        // 1 sources

                        {
                            var7_8[var8_9] = var1_1[var8_9];
                            ++var8_9;
                            continue;
                        }
lbl24:
                        // 1 sources

                        var7_8[var5_4] = var3_5 < 0 ? (char)(var3_5 + 256) : (char)var3_5;
                        var1_1 = var7_8;
                    }
                    ++var5_4;
                } else if (var3_5 == 60) {
                    var4_3 = true;
                }
                var3_5 = -1;
                var3_5 = var0.read();
            }
            if (var4_3) {
                throw new TagInvalidException(1, "EOF reached before end of tag");
            }
            if (var3_5 == -1 || var3_5 == 0) {
                throw new TagInvalidException(0, "no more tags detected before end of file");
            }
            var2_2 = Tag.parseTag(var1_1, 0);
        }
        catch (IOException var3_6) {
            throw new TagInvalidException(2, "IOException thrown : " + var3_6.toString());
        }
        return var2_2;
    }

    protected static Tag parseEndTags(char[] cArray, int n) {
        switch (cArray[n]) {
            case 'H': 
            case 'h': {
                return Tag.parseHEndTags(cArray, n + 1);
            }
            case 'L': 
            case 'l': {
                return Tag.parseLEndTags(cArray, n + 1);
            }
            case 'O': 
            case 'o': {
                return Tag.parseOEndTags(cArray, n + 1);
            }
            case 'U': 
            case 'u': {
                return Tag.parseUEndTags(cArray, n + 1);
            }
        }
        return new Tag();
    }

    protected static Tag parseOEndTags(char[] cArray, int n) {
        if (cArray[n] != 'b' && cArray[n] != 'B') {
            return new Tag();
        }
        if (cArray[++n] != 'j' && cArray[n] != 'J') {
            return new Tag();
        }
        if (cArray[++n] != 'e' && cArray[n] != 'E') {
            return new Tag();
        }
        if (cArray[++n] != 'c' && cArray[n] != 'C') {
            return new Tag();
        }
        if (cArray[++n] != 't' && cArray[n] != 'T') {
            return new Tag();
        }
        if (cArray[++n] != '\u0000') {
            return new Tag();
        }
        return new ObjectEndTag();
    }
}

