/*
 * Decompiled with CFR 0.152.
 */
package treeview;

import bssccom.BsscScrollbar;
import hhapplet.BsscFontFixPatch;
import java.applet.Applet;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Event;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import treeview.ImageSet;
import treeview.ImageSetSource;
import treeview.TreeViewConnectorImageSet;
import treeview.TreeViewNode;

public class TreeView
extends Panel
implements ImageSetSource {
    protected int m_nLabelOffset;
    protected ImageSet m_isImages;
    protected ImageSet m_isConnectors;
    protected TreeViewNode m_tvnRoot;
    protected boolean m_bLayoutComplete;
    protected boolean m_bUseButtons;
    protected boolean m_bUseLines;
    protected boolean m_bRootsConnected;
    protected Applet m_applet;
    protected TreeViewNode m_tvnCurrentSelection;
    protected Image m_imgDoubleBuffer;
    protected Rectangle m_rectDisplayArea;
    protected Scrollbar m_sbHorizontal;
    protected Scrollbar m_sbVertical;
    protected BsscScrollbar m_sbBsscHorizontal;
    protected BsscScrollbar m_sbBsscVertical;
    protected boolean m_bIsClumsyNS4;
    protected Button m_btnScrollerCorner;
    protected int m_nInsetX;
    protected int m_nInsetY;
    protected int m_nConnectorWidth;
    protected int m_nIndent;
    protected int m_nIconWidth;
    protected int m_nIconHeight;
    protected int m_nCellHeight;
    protected int m_nFontBaseOffset;
    private boolean m_bNetscapeScrollers;
    private boolean m_bLayedOutByMouseOver;
    private boolean m_bCompletelyFilled;
    private int m_nHorizPosPixels;
    private int m_nVerticalPosPixels;
    private int m_nImageWidth;
    private int m_nImageHeight;
    public static final int LEAF = 0;
    public static final int BRANCH_COLLAPSED = 1;
    public static final int BRANCH_EXPANDED = 2;
    public static final int LEAF_SELECTED = 3;
    public static final int BRANCH_COLLAPSED_SELECTED = 4;
    public static final int BRANCH_EXPANDED_SELECTED = 5;
    public static final int MIN_NUMBER_IMAGES = 3;
    public static final int MIN_NUMBER_IMAGES_SELECTED = 6;
    protected static final int HEIGHT_HORIZONTAL_SB = 16;
    protected static final int WIDTH_VERTICAL_SB = 16;
    protected static final int ICON_VERTICAL_PADDING = 1;
    protected long c_lnDoubleClickWindow;
    private boolean m_bIsNS3Win32;
    private boolean m_bIsNSWin16;
    private boolean m_bIsUnix;
    private long m_lnLastClickTime;
    private boolean m_bIsMac;
    private boolean m_bNeedTreeSize;
    protected boolean m_bMaxWidthIsValid;
    protected boolean m_bMaxHeightIsValid;
    private int m_nMaxWidth;
    private int m_nMaxHeight;
    private boolean m_bUseDoubleBuffer;
    private Object m_Cursor;

    public boolean mouseEnter(Event event, int n, int n2) {
        TreeViewNode treeViewNode;
        if (this.m_bIsClumsyNS4 ? event.target == this.m_sbBsscHorizontal || event.target == this.m_sbBsscVertical : event.target == this.m_sbHorizontal || event.target == this.m_sbVertical) {
            return super.mouseEnter(event, n, n2);
        }
        if (!this.m_bLayoutComplete) {
            this.mylayout();
        }
        if (this.m_applet != null && (treeViewNode = this.nodeAtLocation(n, n2)) != null && this.m_bCompletelyFilled) {
            this.m_applet.showStatus(treeViewNode.getLabel());
        }
        return false;
    }

    public boolean gotFocus(Event event, Object object) {
        if (this.m_tvnCurrentSelection == null) {
            this.setSelectionToTop();
            this.repaint();
        }
        return true;
    }

    public void MoveSelectionDown() {
        this.MoveSelectionDown(true);
    }

    public void MoveSelectionDown(boolean bl) {
        if (this.m_tvnCurrentSelection.nextNode(true) == null) {
            return;
        }
        this.m_tvnCurrentSelection.select(false);
        this.m_tvnCurrentSelection = this.m_tvnCurrentSelection.nextNode(true);
        this.m_tvnCurrentSelection.select(true);
        this.EnsureDisplayed(this.m_tvnCurrentSelection);
        if (bl) {
            this.InternalSelectionHasChanged();
        }
        this.repaint();
    }

    public void ScrollSubTreeIntoView(TreeViewNode treeViewNode) {
        if (treeViewNode == null) {
            return;
        }
        int n = this.GetNodePosition(treeViewNode);
        if (this.m_bIsClumsyNS4) {
            if (n < this.m_sbBsscVertical.getValue()) {
                this.m_sbBsscVertical.setValue(n);
            } else {
                int n2 = this.GetOpenChildSiblingCount((TreeViewNode)treeViewNode.getChild());
                int n3 = this.m_rectDisplayArea.height / this.m_nCellHeight - 1;
                if (n2 > 0) {
                    if (n2 >= n3 - 1) {
                        this.m_sbBsscVertical.setValue(n);
                    } else if (this.m_sbBsscVertical.getValue() < n - (n3 - n2)) {
                        this.m_sbBsscVertical.setValue(n - (n3 - n2 - 1));
                    }
                }
            }
            this.m_nVerticalPosPixels = this.m_sbBsscVertical.getValue() * this.m_nCellHeight;
            return;
        }
        if (n < this.m_sbVertical.getValue()) {
            this.m_sbVertical.setValue(n);
        } else {
            int n4 = this.GetOpenChildSiblingCount((TreeViewNode)treeViewNode.getChild());
            int n5 = this.m_rectDisplayArea.height / this.m_nCellHeight - 1;
            if (n4 > 0) {
                if (n4 >= n5 - 1) {
                    this.m_sbVertical.setValue(n);
                } else if (this.m_sbVertical.getValue() < n - (n5 - n4)) {
                    this.m_sbVertical.setValue(n - (n5 - n4 - 1));
                }
            }
        }
        this.m_nVerticalPosPixels = this.m_sbVertical.getValue() * this.m_nCellHeight;
    }

    public int getLabelOffset() {
        return this.m_nLabelOffset;
    }

    public void setLabelOffset(int n) {
        this.m_nLabelOffset = n;
    }

    public void CollapseTree() {
        this.m_bMaxHeightIsValid = false;
        this.m_bMaxWidthIsValid = false;
        this.m_tvnCurrentSelection.collapseTree();
        this.mylayout();
        this.repaint();
    }

    protected int getMaxWidth(TreeViewNode treeViewNode, int n, boolean bl) {
        if (!this.m_bMaxWidthIsValid) {
            this.m_nMaxWidth = this.getMaxSubTreeWidth(treeViewNode, n, bl);
        }
        return this.m_nMaxWidth;
    }

    public void expandAll() {
        this.m_bMaxHeightIsValid = false;
        this.m_bMaxWidthIsValid = false;
        try {
            this.m_tvnRoot.expandTree();
            return;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return;
        }
    }

    public int GetNodePosition(TreeViewNode treeViewNode) {
        TreeViewNode treeViewNode2 = this.m_tvnRoot;
        int n = 0;
        while (treeViewNode2 != null) {
            if (treeViewNode == treeViewNode2) {
                return n;
            }
            if (treeViewNode2.getLabel() != null) {
                ++n;
            }
            treeViewNode2 = treeViewNode2.nextNode(true);
        }
        return -1;
    }

    public void Sync(TreeViewNode treeViewNode) {
        if (treeViewNode != null) {
            try {
                while (!this.m_bLayoutComplete) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
            TreeViewNode treeViewNode2 = (TreeViewNode)treeViewNode.getParent();
            while (treeViewNode2 != null && treeViewNode2.m_bCollapsed) {
                if (!treeViewNode2.m_bCollapsed) continue;
                treeViewNode2.m_bCollapsed = false;
                treeViewNode2 = (TreeViewNode)treeViewNode2.getParent();
            }
            if (this.m_tvnCurrentSelection != null) {
                this.m_tvnCurrentSelection.select(false);
            }
            this.m_tvnCurrentSelection = treeViewNode;
            this.m_tvnCurrentSelection.select(true);
            this.mylayout();
            this.EnsureDisplayed(this.m_tvnCurrentSelection);
            this.InternalSelectionHasChanged();
            this.repaint();
        }
    }

    public synchronized void mylayout() {
        this.m_bLayoutComplete = false;
        this.m_rectDisplayArea.reshape(0, 0, this.bounds().width, this.bounds().height);
        if (this.m_rectDisplayArea.width < 1 || this.m_rectDisplayArea.height < 1) {
            return;
        }
        try {
            int n;
            if (this.m_bNeedTreeSize) {
                this.sizeTree(this.m_tvnRoot);
            }
            int n2 = this.getMaxWidth(this.m_tvnRoot, 0, true);
            int n3 = this.getMaxHeight(this.m_tvnRoot, 0, true) / this.m_nCellHeight;
            if (n3 < 1) {
                return;
            }
            if (n2 + 1 > this.m_rectDisplayArea.width) {
                this.m_rectDisplayArea.height -= 16;
            }
            if (n3 > (n = this.m_rectDisplayArea.height / this.m_nCellHeight)) {
                this.m_rectDisplayArea.width -= 16;
            }
            if (this.m_bIsClumsyNS4) {
                this.rods_reshape(this.m_sbBsscHorizontal, 0, this.m_rectDisplayArea.height, this.m_rectDisplayArea.width, 16);
                this.m_sbBsscHorizontal.setValues(this.m_nHorizPosPixels, this.m_rectDisplayArea.width, 0, n2 - (this.m_bNetscapeScrollers ? this.m_rectDisplayArea.width : 0));
            } else {
                this.rods_reshape(this.m_sbHorizontal, 0, this.m_rectDisplayArea.height, this.m_rectDisplayArea.width, 16);
                this.m_sbHorizontal.setValues(this.m_nHorizPosPixels, this.m_rectDisplayArea.width, 0, n2 - (this.m_bNetscapeScrollers ? this.m_rectDisplayArea.width : 0));
            }
            if (this.m_bIsClumsyNS4) {
                this.rods_reshape(this.m_sbBsscVertical, this.m_rectDisplayArea.width, 0, 16, this.m_rectDisplayArea.height);
            } else {
                this.rods_reshape(this.m_sbVertical, this.m_rectDisplayArea.width, 0, 16, this.m_rectDisplayArea.height);
            }
            int n4 = this.m_nVerticalPosPixels / this.m_nCellHeight;
            if (n4 + n > n3) {
                n4 = n3 - n;
            }
            if (n4 < 0) {
                n4 = 0;
            }
            if (this.m_bIsClumsyNS4) {
                this.m_sbBsscVertical.setValues(n4, n - 1, 0, n3 - (this.m_bNetscapeScrollers ? n : 1));
                this.m_nVerticalPosPixels = this.m_sbBsscVertical.getValue() * this.m_nCellHeight;
            } else {
                this.m_sbVertical.setValues(n4, n - 1, 0, n3 - (this.m_bNetscapeScrollers ? n : 1));
                this.m_nVerticalPosPixels = this.m_sbVertical.getValue() * this.m_nCellHeight;
            }
            this.rods_reshape(this.m_btnScrollerCorner, this.m_rectDisplayArea.width, this.m_rectDisplayArea.height, 16, 16);
            if (this.m_rectDisplayArea.height < 0) {
                this.m_rectDisplayArea.height = 0;
            }
            if (this.m_rectDisplayArea.width < 0) {
                this.m_rectDisplayArea.width = 0;
            }
            if (this.m_imgDoubleBuffer != null && (this.m_nImageWidth != this.m_rectDisplayArea.width || this.m_nImageHeight != this.m_rectDisplayArea.height)) {
                this.m_imgDoubleBuffer.flush();
                this.m_imgDoubleBuffer = null;
            }
            if (this.m_imgDoubleBuffer == null) {
                this.m_imgDoubleBuffer = this.createImage(this.m_rectDisplayArea.width, this.m_rectDisplayArea.height);
                this.m_nImageWidth = this.m_rectDisplayArea.width;
                this.m_nImageHeight = this.m_rectDisplayArea.height;
            }
            this.m_bLayoutComplete = true;
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.m_imgDoubleBuffer = null;
            return;
        }
    }

    protected void sizeTree(TreeViewNode treeViewNode) {
        TreeViewNode treeViewNode2 = treeViewNode;
        while (treeViewNode2 != null) {
            this.sizeNode(treeViewNode2);
            this.sizeTree((TreeViewNode)treeViewNode2.getChild());
            treeViewNode2 = (TreeViewNode)treeViewNode2.getSibling();
        }
        this.m_bNeedTreeSize = false;
    }

    public void setSelectionToTop() {
        if (this.m_tvnCurrentSelection != null) {
            this.m_tvnCurrentSelection.select(false);
        }
        this.m_tvnCurrentSelection = this.m_tvnRoot;
        while (this.m_tvnCurrentSelection != null) {
            if (this.m_tvnCurrentSelection.getLabel() != null) break;
            this.m_tvnCurrentSelection = this.m_tvnCurrentSelection.nextNode(true);
        }
        if (this.m_tvnCurrentSelection != null) {
            this.m_tvnCurrentSelection.select(true);
        }
    }

    public int getCellHeight() {
        return this.m_nCellHeight;
    }

    public void setCellHeight(int n) {
        if (n < this.m_nIconHeight + 1) {
            this.m_nCellHeight = this.m_nIconHeight + 1;
            return;
        }
        this.m_nCellHeight = n;
    }

    public void layout() {
        if (this.m_bLayoutComplete) {
            this.mylayout();
        }
    }

    public boolean IsDisplayed(TreeViewNode treeViewNode) {
        TreeViewNode treeViewNode2 = this.GetFirstDisplayedNode();
        int n = this.m_rectDisplayArea.height / this.m_nCellHeight;
        while (treeViewNode2 != null && n > 0) {
            if (treeViewNode2.getLabel() != null) {
                --n;
            }
            if (treeViewNode == treeViewNode2) {
                return true;
            }
            treeViewNode2 = treeViewNode2.nextNode(true);
        }
        return false;
    }

    protected void toggleOpenCloseNode(TreeViewNode treeViewNode) {
        this.m_bMaxHeightIsValid = false;
        this.m_bMaxWidthIsValid = false;
        treeViewNode.setCollapsedState(!treeViewNode.getCollapsedState());
        if (treeViewNode.getCollapsedState()) {
            this.m_tvnCurrentSelection.select(false);
            TreeViewNode treeViewNode2 = (TreeViewNode)this.m_tvnCurrentSelection.getParent();
            while (treeViewNode2 != null) {
                if (treeViewNode2.getCollapsedState()) {
                    this.m_tvnCurrentSelection = treeViewNode2;
                }
                treeViewNode2 = (TreeViewNode)treeViewNode2.getParent();
            }
            this.m_tvnCurrentSelection.select(true);
            this.InternalSelectionHasChanged();
            int n = this.getMaxHeight(this.m_tvnRoot, 0, true) / this.m_nCellHeight - 1;
            int n2 = this.m_rectDisplayArea.height / this.m_nCellHeight;
            int n3 = this.m_nVerticalPosPixels / this.m_nCellHeight;
            if (n3 + n2 > n) {
                n3 = Math.max(n - n2, 0);
            }
            this.m_nVerticalPosPixels = n3 * this.m_nCellHeight;
            return;
        }
        this.mylayout();
        this.ScrollSubTreeIntoView(this.m_tvnCurrentSelection);
    }

    public TreeViewNode nextVisibleNode() {
        try {
            return this.m_tvnRoot.nextNode(true);
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return null;
        }
    }

    public TreeViewNode previousVisibleNode() {
        try {
            return this.m_tvnRoot.prevNode(true);
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void setTopIndex(int n) {
        int n2 = this.m_rectDisplayArea.height / this.m_nCellHeight;
        int n3 = this.getMaxHeight(this.m_tvnRoot, 0, true) / this.m_nCellHeight - 1;
        this.m_nVerticalPosPixels = n * this.m_nCellHeight;
        if (this.m_bIsClumsyNS4) {
            this.m_sbBsscVertical.setValues(n, n2 - 1, 0, n3 - (this.m_bNetscapeScrollers ? n2 : 1));
        } else {
            this.m_sbVertical.setValues(n, n2 - 1, 0, n3 - (this.m_bNetscapeScrollers ? n2 : 1));
        }
        this.paintAll(this.getGraphics());
    }

    public void MoveSelectionHome() {
        this.setSelectionToTop();
        if (this.m_bIsClumsyNS4) {
            this.m_sbBsscVertical.setValue(0);
            this.m_nVerticalPosPixels = this.m_sbBsscVertical.getValue() * this.m_nCellHeight;
        } else {
            this.m_sbVertical.setValue(0);
            this.m_nVerticalPosPixels = this.m_sbVertical.getValue() * this.m_nCellHeight;
        }
        this.repaint();
    }

    public void CollapseBranch() {
        this.m_bMaxHeightIsValid = false;
        this.m_bMaxWidthIsValid = false;
        this.m_tvnCurrentSelection.setCollapsedState(true);
        this.mylayout();
        this.repaint();
    }

    public boolean mouseExit(Event event, int n, int n2) {
        if (this.m_bIsClumsyNS4 ? event.target == this.m_sbBsscHorizontal || event.target == this.m_sbBsscVertical : event.target == this.m_sbHorizontal || event.target == this.m_sbVertical) {
            return super.mouseExit(event, n, n2);
        }
        if (this.m_applet != null && this.m_bCompletelyFilled) {
            this.m_applet.showStatus("");
        }
        return false;
    }

    public void setFilled(boolean bl) {
        this.m_bCompletelyFilled = bl;
        this.m_bLayoutComplete = false;
        this.m_bNeedTreeSize = true;
        this.m_bMaxHeightIsValid = false;
        this.m_bMaxWidthIsValid = false;
        this.repaint();
    }

    public void setApplet(Applet applet) {
        this.m_applet = applet;
    }

    protected void rods_reshape(Component component, int n, int n2, int n3, int n4) {
        component.move(n, n2);
        component.resize(n3, n4);
    }

    public boolean getUseLines() {
        return this.m_bUseLines;
    }

    public TreeViewNode getRoot() {
        return this.m_tvnRoot;
    }

    public void setRoot(TreeViewNode treeViewNode) {
        this.m_tvnRoot = treeViewNode;
        this.setSelectionToTop();
    }

    public void setUseLines(boolean bl) {
        this.m_bUseLines = bl;
    }

    protected void InternalSelectionHasChanged() {
    }

    protected int drawConnector(Graphics graphics, TreeViewNode treeViewNode, int n, int n2) {
        if (this.m_bUseButtons && this.m_bUseLines) {
            Image image = null;
            Image image2 = null;
            try {
                if (treeViewNode.getChild() != null) {
                    image = treeViewNode.getCollapsedState() ? this.m_isConnectors.getImage(5) : this.m_isConnectors.getImage(6);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
                image = null;
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                image = null;
            }
            try {
                image2 = treeViewNode.getParent() == null ? (this.m_bRootsConnected ? (treeViewNode.getSiblingLeft() == null ? (treeViewNode.getSibling() == null ? this.m_isConnectors.getImage(1) : this.m_isConnectors.getImage(2)) : (treeViewNode.getSibling() == null ? this.m_isConnectors.getImage(4) : this.m_isConnectors.getImage(3))) : this.m_isConnectors.getImage(1)) : (treeViewNode.getSiblingLeft() == null && treeViewNode.getParent() != null && ((TreeViewNode)treeViewNode.getParent()).getLabel() == null ? this.m_isConnectors.getImage(2) : (treeViewNode.getSibling() == null ? this.m_isConnectors.getImage(4) : this.m_isConnectors.getImage(3)));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
                image2 = null;
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                image2 = null;
            }
            if (image2 != null) {
                graphics.drawImage(image2, n, n2, this);
            }
            if (image != null) {
                graphics.drawImage(image, n, n2, this);
            }
            n += this.m_nConnectorWidth;
        } else if (this.m_bUseButtons) {
            Image image = null;
            try {
                if (treeViewNode.getChild() != null) {
                    image = treeViewNode.getCollapsedState() ? this.m_isConnectors.getImage(5) : this.m_isConnectors.getImage(6);
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
                image = null;
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                image = null;
            }
            if (image != null) {
                graphics.drawImage(image, n, n2, this);
            }
            n += this.m_nConnectorWidth;
        } else if (this.m_bUseLines) {
            Image image = null;
            try {
                image = treeViewNode.getParent() == null ? (this.m_bRootsConnected ? (treeViewNode.getSiblingLeft() == null ? (treeViewNode.getSibling() == null ? this.m_isConnectors.getImage(1) : this.m_isConnectors.getImage(2)) : (treeViewNode.getSibling() == null ? this.m_isConnectors.getImage(4) : this.m_isConnectors.getImage(3))) : this.m_isConnectors.getImage(1)) : (treeViewNode.getSibling() == null ? this.m_isConnectors.getImage(4) : this.m_isConnectors.getImage(3));
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                indexOutOfBoundsException.printStackTrace();
                image = null;
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
                image = null;
            }
            if (image != null) {
                graphics.drawImage(image, n, n2, this);
            }
            n += this.m_nConnectorWidth;
        }
        return n;
    }

    protected void paintBorder(Graphics graphics) {
        Rectangle rectangle = this.m_rectDisplayArea;
        Color color = this.getBackground();
        Color color2 = color.darker();
        Color color3 = color2.darker();
        Color color4 = color3.darker();
        graphics.setColor(color3);
        graphics.drawLine(0, 0, rectangle.width - 1, 0);
        graphics.drawLine(0, 0, 0, rectangle.height - 1);
        graphics.setColor(color4);
        graphics.drawLine(1, 1, rectangle.width - 2, 1);
        graphics.drawLine(1, 1, 1, rectangle.height - 2);
        graphics.setColor(color2);
        graphics.drawLine(rectangle.width - 2, 1, rectangle.width - 2, rectangle.height - 2);
        graphics.drawLine(1, rectangle.height - 2, rectangle.width - 2, rectangle.height - 2);
        graphics.setColor(color);
        graphics.drawLine(rectangle.width - 1, 1, rectangle.width - 1, rectangle.height - 1);
        graphics.drawLine(0, rectangle.height - 1, rectangle.width - 1, rectangle.height - 1);
    }

    public void collapseAll() {
        this.m_bMaxHeightIsValid = false;
        this.m_bMaxWidthIsValid = false;
        try {
            this.m_tvnRoot.collapseTree();
            return;
        }
        catch (NullPointerException nullPointerException) {
            nullPointerException.printStackTrace();
            return;
        }
    }

    public int getIconHeight() {
        return this.m_nIconHeight;
    }

    public void setIconHeight(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_nIconHeight = n;
        if (n > this.m_nCellHeight - 1) {
            this.m_nCellHeight = n + 1;
        }
    }

    protected int getMaxSubTreeHeight(TreeViewNode treeViewNode, int n, boolean bl) {
        int n2 = n;
        TreeViewNode treeViewNode2 = treeViewNode;
        while (treeViewNode2 != null) {
            n2 += treeViewNode2.getHeight();
            if (!bl || !treeViewNode2.getCollapsedState()) {
                n2 = this.getMaxSubTreeHeight((TreeViewNode)treeViewNode2.getChild(), n2, bl);
            }
            treeViewNode2 = (TreeViewNode)treeViewNode2.getSibling();
        }
        return n2;
    }

    public int getIndent() {
        return this.m_nIndent;
    }

    public void setIndent(int n) {
        this.m_nIndent = n;
    }

    public boolean getRootsConnected() {
        return this.m_bRootsConnected;
    }

    public void setRootsConnected(boolean bl) {
        this.m_bRootsConnected = bl;
    }

    /*
     * Unable to fully structure code
     */
    public boolean handleEvent(Event var1_1) {
        switch (var1_1.id) {
            case 501: {
                if (!(this.m_bIsClumsyNS4 == false ? var1_1.target == this.m_sbHorizontal || var1_1.target == this.m_sbVertical : var1_1.target == this.m_sbBsscHorizontal || var1_1.target == this.m_sbBsscVertical)) {
                    if (!this.m_rectDisplayArea.inside(var1_1.x, var1_1.y)) ** break;
                    var2_2 = var1_1.x + this.m_nHorizPosPixels;
                    var3_3 = 11;
                    var4_4 = this.nodeAtLocation(var1_1.x, var1_1.y);
                    if (var4_4 == null) ** break;
                    v0 = var5_5 = this.m_bIsMac == false && var1_1.clickCount % 2 == 0;
                    if (this.m_bIsUnix || this.m_bIsMac || this.m_bIsNSWin16) {
                        var6_6 = System.currentTimeMillis();
                        if (this.m_lnLastClickTime > var6_6 - this.c_lnDoubleClickWindow) {
                            var5_5 = true;
                            this.m_lnLastClickTime = 0L;
                        } else {
                            this.m_lnLastClickTime = var6_6;
                        }
                    }
                    if (this.m_bIsMac && !var5_5) {
                        var1_1.clickCount = 1;
                    }
                    if (var4_4.getChild() != null && var2_2 > var4_4.getBounds().x && (var2_2 < var4_4.getBounds().x + var3_3 || var5_5)) {
                        this.requestFocus();
                        if (this.m_tvnCurrentSelection != null) {
                            this.m_tvnCurrentSelection.select(false);
                        }
                        this.m_tvnCurrentSelection = var4_4;
                        this.m_tvnCurrentSelection.select(true);
                        this.InternalSelectionHasChanged();
                        var4_4.doAction();
                        this.toggleOpenCloseNode(var4_4);
                        this.mylayout();
                        this.requestFocus();
                        this.repaint();
                    } else if (var2_2 > var4_4.getBounds().x + var3_3 && var1_1.clickCount < 2) {
                        if (this.m_tvnCurrentSelection != null) {
                            this.m_tvnCurrentSelection.select(false);
                        }
                        this.m_tvnCurrentSelection = var4_4;
                        this.m_tvnCurrentSelection.select(true);
                        this.InternalSelectionHasChanged();
                        var4_4.doAction();
                        this.repaint();
                    }
                    if (!var5_5) ** break;
                    var4_4.doDblClick();
                    ** break;
                }
                break;
            }
            case 601: 
            case 602: 
            case 603: 
            case 604: 
            case 605: {
                if (this.m_bIsClumsyNS4) {
                    if (var1_1.target == this.m_sbBsscHorizontal) {
                        this.m_nHorizPosPixels = this.m_sbBsscHorizontal.getValue();
                    } else if (var1_1.target == this.m_sbBsscVertical) {
                        this.m_nVerticalPosPixels = this.m_sbBsscVertical.getValue() * this.m_nCellHeight;
                    }
                } else if (var1_1.target == this.m_sbHorizontal) {
                    this.m_nHorizPosPixels = this.m_sbHorizontal.getValue();
                } else if (var1_1.target == this.m_sbVertical) {
                    this.m_nVerticalPosPixels = this.m_sbVertical.getValue() * this.m_nCellHeight;
                }
                this.repaint();
                ** break;
            }
            case 402: {
                if (System.getProperty("java.vendor").startsWith("Netscape") && System.getProperty("java.version").equalsIgnoreCase("1.1.2") && System.getProperty("os.name").startsWith("Mac")) {
                    this.m_tvnCurrentSelection.doAction();
                    ** break;
                }
                break;
            }
            case 401: {
                switch (var1_1.key) {
                    case 10: {
                        this.m_tvnCurrentSelection.doAction();
                        ** break;
                    }
                    case 45: {
                        this.CollapseBranch();
                        ** break;
                    }
                    case 43: {
                        this.ExpandBranch();
                        ** break;
                    }
                    default: {
                        return super.handleEvent(var1_1);
                    }
                }
            }
            case 403: {
                switch (var1_1.key) {
                    case 10: {
                        this.m_tvnCurrentSelection.doAction();
                        ** break;
                    }
                    case 1004: {
                        this.MoveSelectionUp();
                        ** break;
                    }
                    case 1005: {
                        this.MoveSelectionDown();
                        ** break;
                    }
                    case 1006: {
                        if (this.m_tvnCurrentSelection.getChild() != null && !this.m_tvnCurrentSelection.getCollapsedState()) ** GOTO lbl94
                        if (this.m_tvnCurrentSelection.getParent() != null) {
                            this.MoveSelectionToParent();
                            ** break;
                        }
                        ** GOTO lbl121
lbl94:
                        // 1 sources

                        if ((var1_1.modifiers & 1) == 1) {
                            this.CollapseTree();
                            ** break;
                        }
                        this.CollapseBranch();
                        ** break;
                    }
                    case 1007: {
                        if (this.m_tvnCurrentSelection.getCollapsedState()) ** GOTO lbl105
                        if (this.m_tvnCurrentSelection.getChild() != null) {
                            this.MoveSelectionDown();
                            ** break;
                        }
                        ** GOTO lbl121
lbl105:
                        // 1 sources

                        if ((var1_1.modifiers & 1) == 1) {
                            this.ExpandTree();
                            ** break;
                        }
                        this.ExpandBranch();
                        ** break;
                    }
                    case 1002: {
                        this.MoveSelectionPgUp();
                        ** break;
                    }
                    case 1003: {
                        this.MoveSelectionPgDn();
                        ** break;
                    }
                    case 1001: {
                        this.MoveSelectionEnd();
                        ** break;
                    }
                    case 1000: {
                        this.MoveSelectionHome();
                    }
                }
            }
        }
lbl121:
        // 28 sources

        return super.handleEvent(var1_1);
    }

    public void MoveSelectionToParent() {
        if (this.m_tvnCurrentSelection.getParent() == null) {
            return;
        }
        if (this.m_tvnCurrentSelection.getParent() == this.m_tvnRoot) {
            return;
        }
        this.m_tvnCurrentSelection.select(false);
        this.m_tvnCurrentSelection = (TreeViewNode)this.m_tvnCurrentSelection.getParent();
        this.m_tvnCurrentSelection.select(true);
        this.EnsureDisplayed(this.m_tvnCurrentSelection);
        this.InternalSelectionHasChanged();
        this.repaint();
    }

    public void ExpandTree() {
        this.m_bMaxHeightIsValid = false;
        this.m_bMaxWidthIsValid = false;
        this.m_tvnCurrentSelection.expandTree();
        this.mylayout();
        this.repaint();
    }

    protected int paintTree(Graphics graphics, TreeViewNode treeViewNode, int n, int n2, Rectangle rectangle) {
        TreeViewNode treeViewNode2 = treeViewNode;
        while (treeViewNode2 != null) {
            int n3 = n;
            int n4 = n2;
            if (treeViewNode2.getLabel() != null) {
                if (rectangle.inside(n, n2) || rectangle.inside(n, n2 + this.m_nCellHeight)) {
                    this.paintNode(graphics, treeViewNode2, n, n2);
                }
                n3 += this.m_nIndent;
                n4 += this.m_nCellHeight;
            }
            n2 = !treeViewNode2.getCollapsedState() ? this.paintTree(graphics, (TreeViewNode)treeViewNode2.getChild(), n3, n4, rectangle) : n4;
            treeViewNode2 = (TreeViewNode)treeViewNode2.getSibling();
            if (n4 <= rectangle.y + rectangle.height) continue;
            treeViewNode2 = null;
        }
        return n2;
    }

    protected TreeViewNode nodeAtLocation(int n, int n2) {
        if (!this.m_rectDisplayArea.inside(n, n2)) {
            return null;
        }
        int n3 = n2 + this.m_nVerticalPosPixels;
        TreeViewNode treeViewNode = this.m_tvnRoot;
        while (treeViewNode != null) {
            Rectangle rectangle = treeViewNode.getBounds();
            if (n3 > rectangle.y && n3 <= rectangle.y + rectangle.height && treeViewNode.getLabel() != null) {
                return treeViewNode;
            }
            treeViewNode = treeViewNode.nextNode(true);
        }
        return null;
    }

    public boolean mouseMove(Event event, int n, int n2) {
        if (this.m_bIsClumsyNS4 ? event.target == this.m_sbBsscHorizontal || event.target == this.m_sbBsscVertical : event.target == this.m_sbHorizontal || event.target == this.m_sbVertical) {
            return super.mouseMove(event, n, n2);
        }
        if (!this.m_bLayoutComplete) {
            this.mylayout();
        }
        if (this.m_applet != null) {
            TreeViewNode treeViewNode = this.nodeAtLocation(n, n2);
            if (treeViewNode != null) {
                if (this.m_bCompletelyFilled) {
                    this.m_applet.showStatus(treeViewNode.getLabel());
                }
            } else if (this.m_bCompletelyFilled) {
                this.m_applet.showStatus("");
            }
        }
        return false;
    }

    protected void sizeNode(TreeViewNode treeViewNode) {
        if (treeViewNode == null) {
            return;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = 0;
        if (this.m_bUseButtons || this.m_bUseLines) {
            n = this.m_nIconWidth;
        }
        if (treeViewNode.getCurrentImage() != null) {
            n += this.m_nIconWidth + this.m_nLabelOffset;
        }
        if (treeViewNode.getLabel() != null) {
            n += fontMetrics.stringWidth(treeViewNode.getLabel() + ' ');
        } else if (treeViewNode.getCurrentImage() != null) {
            n -= this.m_nLabelOffset;
        }
        treeViewNode.setBounds(0, 0, n, this.m_nCellHeight);
    }

    public TreeViewNode nextNode(boolean bl) {
        try {
            return (TreeViewNode)this.m_tvnRoot.prevNode();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public TreeViewNode previousNode(boolean bl) {
        try {
            return (TreeViewNode)this.m_tvnRoot.prevNode();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void ExpandBranch() {
        this.m_bMaxHeightIsValid = false;
        this.m_bMaxWidthIsValid = false;
        this.m_tvnCurrentSelection.setCollapsedState(false);
        this.mylayout();
        this.ScrollSubTreeIntoView(this.m_tvnCurrentSelection);
        this.repaint();
    }

    public void update(Graphics graphics) {
        if (!this.m_bLayoutComplete) {
            this.mylayout();
        }
        this.paint(graphics);
    }

    public void ResetCursor() {
        if (System.getProperty("java.version").startsWith("1.0") || System.getProperty("java.vendor").indexOf("Netscape") != -1 && System.getProperty("java.version").startsWith("1.1.2")) {
            return;
        }
        if (this.m_Cursor != null) {
            try {
                this.setCursor((Cursor)this.m_Cursor);
            }
            catch (Exception exception) {}
            this.m_Cursor = null;
        }
    }

    public int getXInset() {
        return this.m_nInsetX;
    }

    public void setXInset(int n) {
        if (n < 0) {
            n = 0;
        }
    }

    public void MoveSelectionUp() {
        this.MoveSelectionUp(true);
    }

    public ImageSet getConnectors() {
        return this.m_isConnectors;
    }

    public void setConnectors(ImageSet imageSet) {
        this.m_isConnectors = imageSet;
    }

    public int getIconWidth() {
        return this.m_nIconWidth;
    }

    public void setIconWidth(int n) {
        if (n < 0) {
            n = 0;
        }
        this.m_nIconWidth = n;
    }

    public void MoveSelectionUp(boolean bl) {
        if (this.m_tvnCurrentSelection.prevNode(true) == null) {
            return;
        }
        if (this.m_tvnCurrentSelection.prevNode(true) == this.m_tvnRoot) {
            return;
        }
        this.m_tvnCurrentSelection.select(false);
        this.m_tvnCurrentSelection = this.m_tvnCurrentSelection.prevNode(true);
        this.m_tvnCurrentSelection.select(true);
        this.EnsureDisplayed(this.m_tvnCurrentSelection);
        if (bl) {
            this.InternalSelectionHasChanged();
        }
        this.repaint();
    }

    protected int getMaxSubTreeWidth(TreeViewNode treeViewNode, int n, boolean bl) {
        int n2 = 0;
        TreeViewNode treeViewNode2 = treeViewNode;
        while (treeViewNode2 != null) {
            int n3;
            if (treeViewNode2.getWidth() + n > n2) {
                n2 = treeViewNode2.getWidth() + n;
            }
            if (!(bl && treeViewNode2.getCollapsedState() || (n3 = this.getMaxSubTreeWidth((TreeViewNode)treeViewNode2.getChild(), n + this.m_nIndent, bl)) <= n2)) {
                n2 = n3;
            }
            treeViewNode2 = (TreeViewNode)treeViewNode2.getSibling();
        }
        return n2;
    }

    public boolean isFocusTraversable() {
        return true;
    }

    protected int getMaxHeight(TreeViewNode treeViewNode, int n, boolean bl) {
        if (!this.m_bMaxHeightIsValid) {
            this.m_nMaxHeight = this.getMaxSubTreeHeight(treeViewNode, n, bl);
        }
        return this.m_nMaxHeight;
    }

    public int getYInset() {
        return this.m_nInsetY;
    }

    public void setYInset(int n) {
        if (n < 0) {
            n = 0;
        }
    }

    public void MoveSelectionPgDn() {
        int n = this.m_rectDisplayArea.height / this.m_nCellHeight - 1;
        int n2 = 0;
        while (n2 < n) {
            this.MoveSelectionDown(false);
            ++n2;
        }
        this.InternalSelectionHasChanged();
        this.repaint();
    }

    public TreeView() {
        this(null, null);
    }

    public TreeView(ImageSet imageSet) {
        this(imageSet, null);
    }

    public TreeView(TreeViewNode treeViewNode) {
        this(null, treeViewNode);
    }

    public TreeView(ImageSet imageSet, TreeViewNode treeViewNode) {
        Object var8_3;
        block14: {
            block13: {
                this.m_nLabelOffset = 6;
                this.m_bLayoutComplete = false;
                this.m_bUseButtons = true;
                this.m_bUseLines = false;
                this.m_bRootsConnected = true;
                this.m_applet = null;
                this.m_sbHorizontal = new Scrollbar(0);
                this.m_sbVertical = new Scrollbar(1);
                this.m_sbBsscHorizontal = new BsscScrollbar(0);
                this.m_sbBsscVertical = new BsscScrollbar(1);
                this.m_bIsClumsyNS4 = false;
                this.m_btnScrollerCorner = new Button();
                this.m_nInsetX = 5;
                this.m_nInsetY = 1;
                this.m_nConnectorWidth = 16;
                this.m_nIndent = 7 + this.m_nConnectorWidth;
                this.m_nIconWidth = 16;
                this.m_nIconHeight = 16;
                this.m_nCellHeight = this.m_nIconHeight + 1;
                this.m_nFontBaseOffset = this.m_nIconHeight;
                this.m_bNetscapeScrollers = false;
                this.m_bLayedOutByMouseOver = false;
                this.m_bCompletelyFilled = false;
                this.m_nHorizPosPixels = 0;
                this.m_nVerticalPosPixels = 0;
                this.m_nImageWidth = 0;
                this.m_nImageHeight = 0;
                this.c_lnDoubleClickWindow = 500L;
                this.m_bIsNS3Win32 = false;
                this.m_bIsNSWin16 = false;
                this.m_bIsUnix = false;
                this.m_lnLastClickTime = 0L;
                this.m_bIsMac = false;
                this.m_bNeedTreeSize = true;
                this.m_bMaxWidthIsValid = false;
                this.m_bMaxHeightIsValid = false;
                this.m_nMaxWidth = 0;
                this.m_nMaxHeight = 0;
                this.m_bUseDoubleBuffer = true;
                this.m_Cursor = null;
                try {
                    if (System.getProperty("java.vendor").startsWith("Netscape")) {
                        if (System.getProperty("java.version").startsWith("1.0") && System.getProperty("os.name").startsWith("Windows") && System.getProperty("os.version").startsWith("4")) {
                            this.m_bIsNS3Win32 = true;
                        } else if (System.getProperty("os.name").startsWith("16-bit Windows")) {
                            this.c_lnDoubleClickWindow = 1500L;
                            this.m_bIsNSWin16 = true;
                        }
                    }
                    if (!System.getProperty("java.vendor").startsWith("Netscape") || !System.getProperty("java.version").startsWith("1.1.5") || !System.getProperty("os.name").startsWith("Windows")) break block13;
                    this.m_bIsClumsyNS4 = true;
                }
                catch (Throwable throwable) {
                    Object var8_4 = null;
                    throw throwable;
                }
            }
            var8_3 = null;
            this.m_tvnRoot = treeViewNode;
            this.m_isImages = imageSet;
            this.m_isConnectors = new TreeViewConnectorImageSet();
            this.m_imgDoubleBuffer = null;
            this.m_rectDisplayArea = new Rectangle();
            this.setLayout(null);
            try {
                String string = System.getProperty("os.name");
                if (string.startsWith("Windows")) break block14;
                this.m_bIsMac = string.startsWith("Mac");
                this.m_bIsUnix = !this.m_bIsMac;
            }
            catch (Throwable throwable) {
                var8_3 = null;
                throw throwable;
            }
        }
        var8_3 = null;
        int n = BsscFontFixPatch.GetFontSize();
        ((Component)this).setFont(new Font(BsscFontFixPatch.GetFontName(), 0, n));
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.getLeading() + fontMetrics.getAscent() + fontMetrics.getDescent();
        this.setCellHeight(n2);
        this.m_nFontBaseOffset = n2 < this.m_nCellHeight ? (this.m_nCellHeight + n2) / 2 - fontMetrics.getDescent() : this.m_nCellHeight - fontMetrics.getDescent();
        this.setSelectionToTop();
        Scrollbar scrollbar = new Scrollbar();
        scrollbar.setValues(0, 3, 0, 10);
        scrollbar.setValue(10);
        if (!this.m_bIsClumsyNS4) {
            boolean bl = this.m_bNetscapeScrollers = scrollbar.getValue() == 10;
        }
        if (this.m_bIsClumsyNS4) {
            this.m_sbBsscHorizontal.setLineIncrement(16);
            if (this.m_sbBsscHorizontal.getPageIncrement() < 128) {
                this.m_sbBsscHorizontal.setPageIncrement(128);
            }
            this.m_sbBsscHorizontal.setBackground(new Color(192, 192, 192));
            this.add(this.m_sbBsscHorizontal);
            this.m_sbBsscVertical.setBackground(new Color(192, 192, 192));
            this.add(this.m_sbBsscVertical);
        } else {
            this.m_sbHorizontal.setLineIncrement(16);
            if (this.m_sbHorizontal.getPageIncrement() < 128) {
                this.m_sbHorizontal.setPageIncrement(128);
            }
            this.m_sbHorizontal.setBackground(new Color(192, 192, 192));
            this.add(this.m_sbHorizontal);
            this.m_sbVertical.setBackground(new Color(192, 192, 192));
            this.add(this.m_sbVertical);
        }
        this.m_btnScrollerCorner.enable(false);
        this.add(this.m_btnScrollerCorner);
    }

    public void EnsureDisplayed(TreeViewNode treeViewNode) {
        int n = this.m_rectDisplayArea.height / this.m_nCellHeight;
        if (this.IsDisplayed(treeViewNode)) {
            return;
        }
        int n2 = this.GetNodePosition(treeViewNode);
        if (this.m_bIsClumsyNS4) {
            if (n2 < this.m_sbBsscVertical.getValue()) {
                this.m_sbBsscVertical.setValue(n2);
            } else {
                this.m_sbBsscVertical.setValue(n2 - n + 1);
            }
            this.m_nVerticalPosPixels = this.m_sbBsscVertical.getValue() * this.m_nCellHeight;
            return;
        }
        if (n2 < this.m_sbVertical.getValue()) {
            this.m_sbVertical.setValue(n2);
        } else {
            this.m_sbVertical.setValue(n2 - n + 1);
        }
        this.m_nVerticalPosPixels = this.m_sbVertical.getValue() * this.m_nCellHeight;
    }

    public int GetOpenChildSiblingCount(TreeViewNode treeViewNode) {
        TreeViewNode treeViewNode2;
        int n = 0;
        if (treeViewNode == null) {
            return 0;
        }
        if (treeViewNode.getLabel() != null) {
            ++n;
        }
        if (!treeViewNode.getCollapsedState() && (treeViewNode2 = (TreeViewNode)treeViewNode.getChild()) != null) {
            n += this.GetOpenChildSiblingCount(treeViewNode2);
        }
        if ((treeViewNode2 = (TreeViewNode)treeViewNode.getSibling()) != null) {
            n += this.GetOpenChildSiblingCount(treeViewNode2);
        }
        return n;
    }

    public void paint(Graphics graphics) {
        try {
            Object object;
            if (!this.m_bLayoutComplete) {
                object = "Loading contents, please wait...";
                graphics.drawChars(((String)object).toCharArray(), 0, ((String)object).length(), 0, 10);
                this.mylayout();
            }
            if (this.m_bUseDoubleBuffer && this.m_imgDoubleBuffer == null) {
                return;
            }
            if (this.m_bIsNS3Win32) {
                graphics.dispose();
            }
            object = null;
            object = this.m_bUseDoubleBuffer ? this.m_imgDoubleBuffer.getGraphics() : this.getGraphics();
            ((Graphics)object).setFont(this.getFont());
            ((Graphics)object).setColor(this.getBackground());
            ((Graphics)object).fillRect(0, 0, this.bounds().width, this.bounds().height);
            ((Graphics)object).setColor(this.getForeground());
            ((Graphics)object).translate(-this.m_nHorizPosPixels, -this.m_nVerticalPosPixels);
            try {
                Rectangle rectangle = new Rectangle(this.m_rectDisplayArea.x, this.m_rectDisplayArea.y, this.m_rectDisplayArea.width, this.m_rectDisplayArea.height);
                rectangle.y += this.m_nVerticalPosPixels;
                this.paintTree((Graphics)object, this.m_tvnRoot, this.m_nInsetX, this.m_nInsetY, rectangle);
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            if (this.m_bUseDoubleBuffer) {
                ((Graphics)object).dispose();
                object = this.m_imgDoubleBuffer.getGraphics();
            } else {
                ((Graphics)object).translate(this.m_nHorizPosPixels, this.m_nVerticalPosPixels);
            }
            this.paintBorder((Graphics)object);
            if (this.m_bUseDoubleBuffer) {
                if (this.m_bIsNS3Win32) {
                    ((Graphics)object).dispose();
                    graphics = this.getGraphics();
                }
                graphics.drawImage(this.m_imgDoubleBuffer, 0, 0, this);
                return;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void paintNode(Graphics graphics, TreeViewNode treeViewNode, int n, int n2) {
        treeViewNode.moveBounds(n, n2);
        n = this.drawConnector(graphics, treeViewNode, n, n2);
        if (treeViewNode.getCurrentImage() != null) {
            graphics.drawImage(treeViewNode.getCurrentImage(), n, n2 + 1, this.m_nIconWidth, this.m_nIconHeight, this);
            n += this.m_nIconWidth + this.m_nLabelOffset;
        }
        if (treeViewNode.getLabel() != null) {
            this.drawText(graphics, treeViewNode, n, n2);
        }
    }

    public void MoveSelectionEnd() {
        this.m_tvnCurrentSelection.select(false);
        while (this.m_tvnCurrentSelection.nextNode(true) != null) {
            this.m_tvnCurrentSelection = this.m_tvnCurrentSelection.nextNode(true);
        }
        this.m_tvnCurrentSelection.select(true);
        if (this.m_bIsClumsyNS4) {
            this.m_sbBsscVertical.setValue(this.m_sbBsscVertical.getMaximum());
            this.m_nVerticalPosPixels = this.m_sbBsscVertical.getValue() * this.m_nCellHeight;
        } else {
            this.m_sbVertical.setValue(this.m_sbVertical.getMaximum());
            this.m_nVerticalPosPixels = this.m_sbVertical.getValue() * this.m_nCellHeight;
        }
        this.InternalSelectionHasChanged();
        this.repaint();
    }

    public void MoveSelectionPgUp() {
        int n = this.m_rectDisplayArea.height / this.m_nCellHeight - 1;
        int n2 = 0;
        while (n2 < n) {
            this.MoveSelectionUp(false);
            ++n2;
        }
        this.InternalSelectionHasChanged();
        this.repaint();
    }

    TreeViewNode GetFirstDisplayedNode() {
        TreeViewNode treeViewNode = this.m_tvnRoot;
        int n = 0;
        n = this.m_bIsClumsyNS4 ? this.m_sbBsscVertical.getValue() : this.m_sbVertical.getValue();
        while (treeViewNode != null && n > 0) {
            if (treeViewNode.getLabel() != null) {
                --n;
            }
            treeViewNode = treeViewNode.nextNode(true);
        }
        return treeViewNode;
    }

    public void SetWaitCursor() {
        if (System.getProperty("java.version").startsWith("1.0") || System.getProperty("java.vendor").indexOf("Netscape") != -1 && System.getProperty("java.version").startsWith("1.1.2")) {
            return;
        }
        try {
            this.m_Cursor = this.getCursor();
            this.setCursor(new Cursor(3));
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public boolean getUseButtons() {
        return this.m_bUseButtons;
    }

    public void setUseButtons(boolean bl) {
        this.m_bUseButtons = bl;
    }

    public ImageSet getImages() {
        return this.m_isImages;
    }

    public void setImages(ImageSet imageSet) {
        this.m_isImages = imageSet;
    }

    protected void drawText(Graphics graphics, TreeViewNode treeViewNode, int n, int n2) {
        n2 += this.m_nFontBaseOffset;
        if (treeViewNode.isSelected()) {
            graphics.setColor(new Color(0, 0, 128));
            Rectangle rectangle = treeViewNode.getBounds();
            int n3 = rectangle.width + rectangle.x - n;
            graphics.fillRect(n, rectangle.y, n3, rectangle.height);
            graphics.setColor(Color.white);
        } else {
            graphics.setColor(this.getForeground());
        }
        graphics.setFont(this.getFont());
        graphics.drawString(treeViewNode.getLabel(), n, n2);
    }
}

