/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.snapnewnodes;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeNodesCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.DeleteCommand;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.UndoRedoHandler;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.DefaultNameFormatter;
import org.openstreetmap.josm.data.osm.NameFormatter;
import org.openstreetmap.josm.data.osm.Node;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.Notification;
import org.openstreetmap.josm.plugins.snapnewnodes.ReplacementPairs;
import org.openstreetmap.josm.plugins.snapnewnodes.SnappingPlace;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.Geometry;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Shortcut;

public final class SnapNewNodesAction
extends JosmAction {
    public SnapNewNodesAction() {
        super(I18n.tr((String)"Snap Ways", (Object[])new Object[0]), "simplify", I18n.tr((String)"Snap a way to another way", (Object[])new Object[0]), Shortcut.registerShortcut((String)"tools:snapnewnodes", (String)I18n.tr((String)"Tool: {0}", (Object[])new Object[]{I18n.tr((String)"Snap Ways", (Object[])new Object[0])}), (int)83, (int)5009), true, "snapnewnodes", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent e) {
        Logging.debug((String)"Snap ways action started");
        double distThreshold = Config.getPref().getDouble("snap-new-nodes.dist.threshold", 10.0);
        long startTime = System.nanoTime();
        DataSet ds = this.getLayerManager().getEditDataSet();
        if (ds == null) {
            return;
        }
        ds.beginUpdate();
        try {
            List selectedWays = ds.getSelectedWays().stream().filter(p -> !p.isIncomplete()).collect(Collectors.toList());
            if (selectedWays.size() != 2) {
                new Notification(I18n.tr((String)"Please select exactly least two ways to snap.", (Object[])new Object[0])).setIcon(1).setDuration(Notification.TIME_SHORT).show();
                return;
            }
            Way srcWay = (Way)selectedWays.get(0);
            Way dstWay = (Way)selectedWays.get(1);
            boolean srcWayIsClosed = srcWay.isClosed();
            Logging.debug((String)"Snapping way {0} to way {1}", (Object[])new Object[]{srcWay.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), dstWay.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())});
            List<ReplacementPairs> replPairs = this.getReplacementPairs(distThreshold, srcWay, dstWay);
            if (replPairs.size() > 0) {
                ReplacementPairs terminatorEntry = new ReplacementPairs();
                terminatorEntry.srcStart = srcWay.getNodesCount() + 1;
                replPairs.add(terminatorEntry);
                ArrayList<Command> allCommands = new ArrayList<Command>();
                ArrayList<Node> newSrcNodes = new ArrayList<Node>();
                ArrayList<Node> newDstNodes = new ArrayList<Node>(dstWay.getNodes());
                this.interleaveSrcSegments(srcWay, dstWay, replPairs, allCommands, newSrcNodes, newDstNodes);
                this.fixSmallAngles(newSrcNodes);
                this.fixSmallAngles(newDstNodes);
                if (srcWayIsClosed) {
                    Node firstNode = (Node)newSrcNodes.get(0);
                    newSrcNodes.set(newSrcNodes.size() - 1, firstNode);
                }
                allCommands.add((Command)new ChangeNodesCommand(srcWay, newSrcNodes));
                allCommands.add((Command)new ChangeNodesCommand(dstWay, newDstNodes));
                this.deleteAbandonedSrcNodes(srcWay, allCommands, newSrcNodes);
                SequenceCommand rootCommand = new SequenceCommand(I18n.tr((String)"Snap nodes from {0} to {1}", (Object[])new Object[]{srcWay.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance()), dstWay.getDisplayName((NameFormatter)DefaultNameFormatter.getInstance())}), allCommands);
                UndoRedoHandler.getInstance().add((Command)rootCommand);
                MainApplication.getMap().repaint();
                String infoMsg = I18n.tr((String)"Snapping finished", (Object[])new Object[0]);
                new Notification(infoMsg).setIcon(1).show();
                Logging.debug((String)infoMsg);
            } else {
                String infoMsg = I18n.tr((String)"No nodes or segments to snap were found.", (Object[])new Object[0]);
                new Notification(infoMsg).setIcon(1).setDuration(Notification.TIME_SHORT).show();
                Logging.debug((String)infoMsg);
            }
        }
        finally {
            ds.endUpdate();
        }
        long endTime = System.nanoTime();
        double durationSeconds = (double)(endTime - startTime) / 1.0E9;
        Logging.debug((String)"It took {0} seconds", (Object[])new Object[]{durationSeconds});
    }

    private void deleteAbandonedSrcNodes(Way way, Collection<Command> allCommands, List<Node> newNodes) {
        ArrayList<Node> deletedNodes = new ArrayList<Node>();
        for (Node n : way.getNodes()) {
            if (newNodes.contains(n) || n.getReferrers().size() > 1) continue;
            deletedNodes.add(n);
        }
        if (!deletedNodes.isEmpty()) {
            DeleteCommand dc = new DeleteCommand(deletedNodes);
            allCommands.add((Command)dc);
        }
    }

    private void interleaveSrcSegments(Way srcWay, Way dstWay, List<ReplacementPairs> replPairs, Collection<Command> allCommands, List<Node> newSrcNodes, List<Node> newDstNodes) {
        int srcWaySize = srcWay.getNodesCount();
        int curPairIndex = 0;
        ArrayList<Pair> dstWayInsertionPairs = new ArrayList<Pair>();
        for (int i = 0; i < srcWaySize; ++i) {
            ReplacementPairs curP = replPairs.get(curPairIndex);
            assert (i <= curP.srcStart);
            if (i == curP.srcStart) {
                assert (curP.srcN != null);
                Node startProj = new Node(curP.srcN);
                AddCommand spcmd = new AddCommand(srcWay.getDataSet(), (OsmPrimitive)startProj);
                allCommands.add((Command)spcmd);
                newSrcNodes.add(startProj);
                Node existingNode1 = dstWay.getNode(curP.dstStart);
                dstWayInsertionPairs.add(new Pair((Object)existingNode1, (Object)startProj));
                int dstStart = curP.dstStart;
                int dstEnd = curP.dstEnd;
                int direction = curP.direction;
                if (direction == 0) {
                    direction = dstStart > dstEnd ? -1 : 1;
                }
                Logging.debug((String)I18n.tr((String)"Copying dest nodes in slice {0}:{1} direction {2}", (Object[])new Object[]{dstStart, dstEnd, direction}));
                int p = dstStart;
                while (p != dstEnd) {
                    Node dstNode = dstWay.getNode(p);
                    newSrcNodes.add(dstNode);
                    assert (direction != 0);
                    if ((p += direction) < 0) {
                        p = dstWay.getNodesCount() - 1;
                        continue;
                    }
                    if (p < dstWay.getNodesCount()) continue;
                    p = 0;
                }
                if (curP.srcStart != curP.srcEnd) {
                    assert (curP.dstN != null);
                    Node endProj = new Node(curP.dstN);
                    AddCommand epcmd = new AddCommand(srcWay.getDataSet(), (OsmPrimitive)endProj);
                    allCommands.add((Command)epcmd);
                    newSrcNodes.add(endProj);
                    Node existingNode2 = dstWay.getNode(curP.dstEnd);
                    dstWayInsertionPairs.add(new Pair((Object)existingNode2, (Object)endProj));
                }
                ++curPairIndex;
                i = curP.srcEnd;
                continue;
            }
            newSrcNodes.add(srcWay.getNode(i));
        }
        block2: for (Pair p : dstWayInsertionPairs) {
            for (int k = 0; k < newDstNodes.size(); ++k) {
                if (!newDstNodes.get(k).equals(p.a)) continue;
                newDstNodes.add(k + 1, (Node)p.b);
                continue block2;
            }
        }
    }

    private void fixSmallAngles(List<Node> nodes) {
        double angleThreshold = 0.5;
        int totalSmallAngledNodes = 0;
        while (nodes.size() > 3) {
            boolean removedNode = false;
            for (int k = 1; k < nodes.size() - 1; ++k) {
                Node prev = nodes.get(k - 1);
                Node middle = nodes.get(k);
                Node next = nodes.get(k + 1);
                if (prev.getCoor().equals((Object)middle.getCoor())) {
                    nodes.remove(k);
                    ++totalSmallAngledNodes;
                    removedNode = true;
                    break;
                }
                double angle = Geometry.getNormalizedAngleInDegrees((double)Geometry.getCornerAngle((EastNorth)prev.getEastNorth(), (EastNorth)middle.getEastNorth(), (EastNorth)next.getEastNorth()));
                if (!(angle < 0.5)) continue;
                nodes.remove(k);
                ++totalSmallAngledNodes;
                removedNode = true;
                break;
            }
            if (removedNode) continue;
            break;
        }
        Logging.debug((String)I18n.tr((String)"Excluded {0} nodes with small angles", (Object[])new Object[]{totalSmallAngledNodes}));
    }

    private List<ReplacementPairs> getReplacementPairs(double distThreshold, Way srcWay, Way dstWay) {
        int srcWaySize = srcWay.getNodesCount();
        ArrayList<ReplacementPairs> replPairs = new ArrayList<ReplacementPairs>();
        ReplacementPairs curPair = new ReplacementPairs();
        SnappingPlace fixedNodeStub = new SnappingPlace(null, Double.POSITIVE_INFINITY, -1);
        for (int i = 0; i < srcWaySize; ++i) {
            int newDirection;
            Node n = srcWay.getNode(i);
            SnappingPlace sp = null;
            if (SnapNewNodesAction.nodeGluesWays(n) || n.isTagged()) {
                sp = fixedNodeStub;
            } else {
                sp = SnapNewNodesAction.calculateNearestPointOnWay(n, dstWay);
                assert (sp.dstIndex >= 0);
            }
            if (curPair.srcStart < 0 && sp.distance <= distThreshold) {
                curPair.srcStart = i;
                curPair.srcN = sp.projectionCoord;
                curPair.dstStart = sp.dstIndex;
                curPair.srcEnd = curPair.srcStart;
                curPair.dstEnd = curPair.dstStart;
                curPair.dstN = curPair.srcN;
                curPair.direction = 0;
                continue;
            }
            if (curPair.srcStart >= 0 && sp.distance > distThreshold) {
                assert (i > 0);
                assert (curPair.srcStart >= 0);
                assert (curPair.dstStart >= 0);
                assert (curPair.dstEnd >= 0);
                assert (curPair.srcEnd >= 0);
                replPairs.add(new ReplacementPairs(curPair));
                curPair.reset();
                continue;
            }
            if (curPair.srcStart < 0 || !(sp.distance <= distThreshold)) continue;
            int deltaDstIndex = sp.dstIndex - curPair.dstEnd;
            int n2 = deltaDstIndex > 0 ? 1 : (newDirection = deltaDstIndex < 0 ? -1 : 0);
            if (curPair.direction == 0 || curPair.direction != newDirection) {
                // empty if block
            }
            curPair.srcEnd = i;
            curPair.dstEnd = sp.dstIndex;
            curPair.dstN = sp.projectionCoord;
            curPair.direction = newDirection;
        }
        if (curPair.srcStart >= 0) {
            replPairs.add(new ReplacementPairs(curPair));
        }
        return replPairs;
    }

    private static Pair<LatLon, Double> calculateNearestPointOnSegment(Node a, Node b, Node c) {
        LatLon a_p = a.getCoor();
        LatLon b_p = b.getCoor();
        LatLon c_p = c.getCoor();
        double roundingThreshold = 1.0E-14;
        double px = c_p.lon() - b_p.lon();
        double py = c_p.lat() - b_p.lat();
        double squaredLength = px * px + py * py;
        double t = 0.0;
        if (Math.abs(squaredLength) > 1.0E-14) {
            t = ((a_p.lon() - b_p.lon()) * px + (a_p.lat() - b_p.lat()) * py) / squaredLength;
        }
        t = Math.max(t, 0.0);
        t = Math.min(t, 1.0);
        double lon = b_p.lon() + t * px;
        double lat = b_p.lat() + t * py;
        LatLon proj = new LatLon(lat, lon);
        double dist = a_p.greatCircleDistance(proj);
        Pair result = new Pair((Object)proj, (Object)dist);
        return result;
    }

    private static SnappingPlace calculateNearestPointOnWay(Node n, Way w) {
        int insPos = -1;
        double minDistance = Double.POSITIVE_INFINITY;
        LatLon newCoords = null;
        for (int k = 0; k < w.getNodesCount() - 1; ++k) {
            Pair<LatLon, Double> res = SnapNewNodesAction.calculateNearestPointOnSegment(n, w.getNode(k), w.getNode(k + 1));
            double distance = (Double)res.b;
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            insPos = k;
            newCoords = (LatLon)res.a;
        }
        return new SnappingPlace(newCoords, minDistance, insPos);
    }

    private static boolean nodeGluesWays(Node node) {
        Set referenceNeighbours = null;
        for (OsmPrimitive ref : node.getReferrers()) {
            if (ref.getType() != OsmPrimitiveType.WAY) continue;
            Way way = (Way)ref;
            Set neighbours = way.getNeighbours(node);
            if (referenceNeighbours == null) {
                referenceNeighbours = neighbours;
                continue;
            }
            if (referenceNeighbours.containsAll(neighbours)) continue;
            return true;
        }
        return false;
    }

    protected void updateEnabledState() {
        if (this.getLayerManager().getEditDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(this.getLayerManager().getEditDataSet().getSelected());
        }
    }

    protected void updateEnabledState(Collection<? extends OsmPrimitive> selection) {
        this.setEnabled(selection != null && !selection.isEmpty());
    }
}

