/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.plugins.snapnewnodes;

import java.awt.Component;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.openstreetmap.josm.gui.preferences.DefaultTabPreferenceSetting;
import org.openstreetmap.josm.gui.preferences.PreferenceTabbedPane;
import org.openstreetmap.josm.gui.preferences.TabPreferenceSetting;
import org.openstreetmap.josm.gui.widgets.JosmTextField;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

public class SnapNewNodesPreferenceSetting
extends DefaultTabPreferenceSetting {
    static final String DIST_THRESHOLD = "snap-new-nodes.dist.threshold";
    static final String CANDIDATE_LENGTH_THRESHOLD = "snap-new-nodes.candidate.threshold";
    private final JTextField distanceThreshold = new JosmTextField(8);
    private final JTextField candidateLengthThreshold = new JosmTextField(8);

    public SnapNewNodesPreferenceSetting() {
        super("snapnewnodes", I18n.tr((String)"Snap New Nodes", (Object[])new Object[0]), I18n.tr((String)"Snap segments of the forst selected way to segments of the second selected way when distance between their nodes is less than specified threshold.", (Object[])new Object[0]));
    }

    public void addGui(PreferenceTabbedPane gui) {
        PreferenceTabbedPane.PreferencePanel tab = gui.createPreferenceTab((TabPreferenceSetting)this);
        this.distanceThreshold.setText(Config.getPref().get(DIST_THRESHOLD, "20"));
        tab.add((Component)new JLabel(I18n.tr((String)"Distance Threshold (in meters)", (Object[])new Object[0])), GBC.std());
        tab.add((Component)this.distanceThreshold, GBC.eol().fill(2).insets(5, 0, 0, 5));
        this.candidateLengthThreshold.setText(Config.getPref().get(CANDIDATE_LENGTH_THRESHOLD, "100"));
        tab.add((Component)new JLabel(I18n.tr((String)"Minimum way length to be eligible for snapping (in meters)", (Object[])new Object[0])), GBC.std());
        tab.add((Component)this.candidateLengthThreshold, GBC.eol().fill(2).insets(5, 0, 0, 5));
        tab.add(Box.createVerticalGlue(), GBC.eol().fill(3));
    }

    public boolean ok() {
        Config.getPref().put(DIST_THRESHOLD, this.distanceThreshold.getText());
        Config.getPref().put(CANDIDATE_LENGTH_THRESHOLD, this.candidateLengthThreshold.getText());
        return false;
    }
}

